/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.iteration;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.IntegerConverter;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.richfaces.demo.iteration.LazyTreeNode;
import org.richfaces.demo.iteration.SelectionChangeActionListenerImpl;
import org.richfaces.demo.iteration.ToggleActionListenerImpl;
import org.richfaces.demo.iteration.TracingSet;
import org.richfaces.demo.iteration.TreeBean;
import org.richfaces.demo.iteration.TreeNodeParser;
import org.richfaces.demo.iteration.model.tree.DataHolderTreeNodeImpl;
import org.richfaces.log.LogFactory;
import org.richfaces.log.Logger;
import org.richfaces.model.TreeDataModel;
import org.richfaces.model.TreeNode;
import org.richfaces.ui.common.SwitchType;
import org.richfaces.ui.iteration.tree.AbstractTree;
import org.richfaces.ui.iteration.tree.AbstractTreeNode;
import org.richfaces.ui.iteration.tree.TreeSelectionChangeEvent;
import org.richfaces.ui.iteration.tree.TreeToggleEvent;
import org.richfaces.ui.iteration.tree.convert.SequenceRowKeyConverter;
import org.richfaces.ui.iteration.tree.model.SwingTreeNodeDataModelImpl;
import org.richfaces.ui.iteration.tree.model.SwingTreeNodeImpl;
import org.richfaces.ui.iteration.tree.model.TreeNodeImpl;

/*
 * Exception performing whole class analysis ignored.
 */
@ManagedBean
@SessionScoped
public class TreeBean
implements Serializable {
    private static final long serialVersionUID = 3368885134614548497L;
    private static final Logger LOGGER = LogFactory.getLogger(TreeBean.class);
    private static final Converter INTEGER_SEQUENCE_KEY_CONVERTER = new SequenceRowKeyConverter(Integer.class, (Converter)new IntegerConverter());
    private List<javax.swing.tree.TreeNode> rootNodes;
    private List<javax.swing.tree.TreeNode> lazyRootNodes;
    private TreeDataModel<?> treeDataModel;
    private SwitchType toggleType = SwitchType.DEFAULT;
    private SwitchType selectionType = SwitchType.client;
    private boolean showCustomClasses = true;
    private Collection<Object> selection = new TracingSet();
    private String toggleNodeEvent = "";
    private String executeTestText;
    private ToggleActionListenerImpl toggleActionListenerImpl = new ToggleActionListenerImpl();
    private SelectionChangeActionListenerImpl selectionChangeActionListener;
    private TreeNode classicTreeNode;

    private static Object staticGetNodeData() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().evaluateExpressionGet(facesContext, "#{node}", Object.class);
    }

    private static FacesMessage createEventMessage(FacesEvent event, boolean fromExpression) {
        String summary = event + (fromExpression ? " called from attribute" : " called from tag") + ", data: " + TreeBean.staticGetNodeData();
        return new FacesMessage(summary);
    }

    private static AbstractTree getTree(FacesEvent event) {
        if (event.getComponent() instanceof AbstractTree) {
            return (AbstractTree)event.getComponent();
        }
        return ((AbstractTreeNode)event.getComponent()).findTreeComponent();
    }

    private List<javax.swing.tree.TreeNode> createLazyNodes(List<javax.swing.tree.TreeNode> nodes) {
        ArrayList<javax.swing.tree.TreeNode> result = new ArrayList<javax.swing.tree.TreeNode>(nodes.size());
        for (javax.swing.tree.TreeNode srcNode : nodes) {
            result.add((javax.swing.tree.TreeNode)new LazyTreeNode(srcNode));
        }
        return result;
    }

    private TreeNode createClassicNode(javax.swing.tree.TreeNode node) {
        DataHolderTreeNodeImpl result = new DataHolderTreeNodeImpl(node.isLeaf(), ((SwingTreeNodeImpl)node).getData());
        for (int i = 0; i < node.getChildCount(); ++i) {
            result.addChild((Object)i, this.createClassicNode(node.getChildAt(i)));
        }
        return result;
    }

    private TreeNode createRootClassicNode(List<javax.swing.tree.TreeNode> nodes) {
        TreeNodeImpl rootNode = new TreeNodeImpl();
        int key = 0;
        for (javax.swing.tree.TreeNode node : nodes) {
            rootNode.addChild((Object)key++, this.createClassicNode(node));
        }
        return rootNode;
    }

    @PostConstruct
    public void init() {
        try {
            TreeNodeParser parser = new TreeNodeParser();
            parser.parse(TreeBean.class.getResource("plants.xml"));
            this.rootNodes = parser.getRootNodes();
            this.lazyRootNodes = this.createLazyNodes(this.rootNodes);
            this.classicTreeNode = this.createRootClassicNode(this.rootNodes);
            this.treeDataModel = new SwingTreeNodeDataModelImpl();
            this.treeDataModel.setWrappedData((Object)this.rootNodes);
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    public List<javax.swing.tree.TreeNode> getRootNodes() {
        return this.rootNodes;
    }

    public List<javax.swing.tree.TreeNode> getLazyRootNodes() {
        return this.lazyRootNodes;
    }

    public TreeNode getClassicTreeNode() {
        return this.classicTreeNode;
    }

    public SwitchType[] getTypes() {
        return SwitchType.values();
    }

    public SwitchType getToggleType() {
        return this.toggleType;
    }

    public void setToggleType(SwitchType switchType) {
        this.toggleType = switchType;
    }

    public SwitchType getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(SwitchType selectionMode) {
        this.selectionType = selectionMode;
    }

    public Object getNodeData() {
        return TreeBean.staticGetNodeData();
    }

    public Collection<Object> getSelection() {
        return this.selection;
    }

    public void setSelection(Collection<Object> selection) {
        this.selection = selection;
    }

    public void clickNode() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.addMessage(null, new FacesMessage("Clicked node: " + this.getNodeData()));
    }

    public boolean isShowCustomClasses() {
        return this.showCustomClasses;
    }

    public void setShowCustomClasses(boolean showCustomClasses) {
        this.showCustomClasses = showCustomClasses;
    }

    public void behaviorToggleListener(AjaxBehaviorEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.addMessage(null, new FacesMessage("Toggle node: " + this.getNodeData() + ", source is: " + event.getSource()));
    }

    public void behaviorSelectionChangeListener(AjaxBehaviorEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.addMessage(event.getComponent().getClientId(facesContext), new FacesMessage("Selection changed, source is: " + event.getSource()));
    }

    public void processSelectionChange(TreeSelectionChangeEvent event) {
        new SelectionChangeHandler(true).processTreeSelectionChange(event);
    }

    public void processToggle(TreeToggleEvent event) {
        new ToggleHandler(true).processTreeToggle(event);
    }

    public String getToggleNodeEvent() {
        return this.toggleNodeEvent;
    }

    public void setToggleNodeEvent(String toggleNodeEvent) {
        this.toggleNodeEvent = toggleNodeEvent;
    }

    public String getExecuteTestText() {
        return this.executeTestText;
    }

    public void setExecuteTestText(String executeTestText) {
        this.executeTestText = executeTestText;
    }

    public String getCurrentTimeAsString() {
        return DateFormat.getTimeInstance().format(new Date());
    }

    public ToggleActionListenerImpl getToggleActionListenerImpl() {
        return this.toggleActionListenerImpl;
    }

    public void setToggleActionListenerImpl(ToggleActionListenerImpl toggleActionListenerImpl) {
        this.toggleActionListenerImpl = toggleActionListenerImpl;
    }

    public SelectionChangeActionListenerImpl getSelectionChangeActionListener() {
        return this.selectionChangeActionListener;
    }

    public void setSelectionChangeActionListener(SelectionChangeActionListenerImpl selectionChangeActionListener) {
        this.selectionChangeActionListener = selectionChangeActionListener;
    }

    public Converter getIntegerSequenceKeyConveter() {
        return INTEGER_SEQUENCE_KEY_CONVERTER;
    }

    public TreeDataModel<?> getTreeDataModel() {
        return this.treeDataModel;
    }

    static /* synthetic */ AbstractTree access$000(FacesEvent x0) {
        return TreeBean.getTree((FacesEvent)x0);
    }

    static /* synthetic */ FacesMessage access$100(FacesEvent x0, boolean x1) {
        return TreeBean.createEventMessage((FacesEvent)x0, (boolean)x1);
    }
}

