/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.swing.tree.TreeNode;
import org.richfaces.component.SwitchType;
import org.richfaces.demo.TracingSet;
import org.richfaces.demo.TreeNodeParser;
import org.richfaces.log.LogFactory;
import org.richfaces.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBean
@SessionScoped
public class TreeBean
implements Serializable {
    private static final long serialVersionUID = 3368885134614548497L;
    private static final Logger LOGGER = LogFactory.getLogger(TreeBean.class);
    private List<TreeNode> rootNodes;
    private SwitchType toggleType = SwitchType.DEFAULT;
    private SwitchType selectionType = SwitchType.client;
    private Object nodeData;
    private Collection<Object> selection = new TracingSet();

    @PostConstruct
    public void init() {
        try {
            TreeNodeParser parser = new TreeNodeParser();
            parser.parse(TreeBean.class.getResource("plants.xml"));
            this.rootNodes = parser.getRootNodes();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    public List<TreeNode> getRootNodes() {
        return this.rootNodes;
    }

    public SwitchType[] getTypes() {
        return SwitchType.values();
    }

    public SwitchType getToggleType() {
        return this.toggleType;
    }

    public void setToggleType(SwitchType switchType) {
        this.toggleType = switchType;
    }

    public SwitchType getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(SwitchType selectionMode) {
        this.selectionType = selectionMode;
    }

    public Object getNodeData() {
        return this.nodeData;
    }

    public void setNodeData(Object nodeData) {
        this.nodeData = nodeData;
    }

    public Collection<Object> getSelection() {
        return this.selection;
    }

    public void setSelection(Collection<Object> selection) {
        this.selection = selection;
    }

    public void clickNode() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.addMessage(null, new FacesMessage("Clicked node: " + this.getNodeData()));
    }
}

