/*
 * JBoss, Home of Professional Open Source
 * Copyright ${year}, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.demo.model.tree.adaptors;

import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;


/**
 * @author Nick Belaevski
 *         mailto:nbelaevski@exadel.com
 *         created 29.07.2007
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
public abstract class Entry {

    @XmlAttribute
    private String name;

    private Entry parent;
    
    public String getPath() {
        List<Entry> entries = Lists.newLinkedList();
        
        Entry entry = this;
        while (entry != null) {
            entries.add(0, entry);
            entry = entry.getParent();
        }
        
        return Joiner.on(" -> ").join(entries);
    }
    
    public void processClick() {
        FacesContext context = FacesContext.getCurrentInstance();
        
        context.addMessage(null, new FacesMessage(getPath()));
    }
    
    public String toString() {
        return getClass().getSimpleName() + " [" + getName() + "]";
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void click() {
    }

    public Entry getParent() {
        return parent;
    }
    
    public void setParent(Entry parent) {
        this.parent = parent;
    }

}
