/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.swing.tree.TreeNode;
import org.richfaces.component.AbstractTree;
import org.richfaces.component.AbstractTreeNode;
import org.richfaces.component.SwitchType;
import org.richfaces.demo.LazyTreeNode;
import org.richfaces.demo.TracingSet;
import org.richfaces.demo.TreeBean;
import org.richfaces.demo.TreeNodeParser;
import org.richfaces.event.TreeSelectionChangeEvent;
import org.richfaces.event.TreeToggleEvent;
import org.richfaces.log.LogFactory;
import org.richfaces.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ManagedBean
@SessionScoped
public class TreeBean
implements Serializable {
    private static final long serialVersionUID = 3368885134614548497L;
    private static final Logger LOGGER = LogFactory.getLogger(TreeBean.class);
    private List<TreeNode> rootNodes;
    private List<TreeNode> lazyRootNodes;
    private SwitchType toggleType = SwitchType.DEFAULT;
    private SwitchType selectionType = SwitchType.client;
    private boolean showCustomClasses = true;
    private Collection<Object> selection = new TracingSet();
    private String toggleNodeEvent = "";
    private String executeTestText;

    private static Object staticGetNodeData() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().evaluateExpressionGet(facesContext, "#{node}", Object.class);
    }

    private static FacesMessage createEventMessage(FacesEvent event, boolean fromExpression) {
        String summary = event + (fromExpression ? " called from attribute" : " called from tag") + ", data: " + TreeBean.staticGetNodeData();
        return new FacesMessage(summary);
    }

    private static AbstractTree getTree(FacesEvent event) {
        if (event.getComponent() instanceof AbstractTree) {
            return (AbstractTree)event.getComponent();
        }
        return ((AbstractTreeNode)event.getComponent()).findTreeComponent();
    }

    private List<TreeNode> createLazyNodes(List<TreeNode> nodes) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(nodes.size());
        for (TreeNode srcNode : nodes) {
            result.add((TreeNode)new LazyTreeNode(srcNode));
        }
        return result;
    }

    @PostConstruct
    public void init() {
        try {
            TreeNodeParser parser = new TreeNodeParser();
            parser.parse(TreeBean.class.getResource("plants.xml"));
            this.rootNodes = parser.getRootNodes();
            this.lazyRootNodes = this.createLazyNodes(this.rootNodes);
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    public List<TreeNode> getRootNodes() {
        return this.rootNodes;
    }

    public List<TreeNode> getLazyRootNodes() {
        return this.lazyRootNodes;
    }

    public SwitchType[] getTypes() {
        return SwitchType.values();
    }

    public SwitchType getToggleType() {
        return this.toggleType;
    }

    public void setToggleType(SwitchType switchType) {
        this.toggleType = switchType;
    }

    public SwitchType getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(SwitchType selectionMode) {
        this.selectionType = selectionMode;
    }

    public Object getNodeData() {
        return TreeBean.staticGetNodeData();
    }

    public Collection<Object> getSelection() {
        return this.selection;
    }

    public void setSelection(Collection<Object> selection) {
        this.selection = selection;
    }

    public void clickNode() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.addMessage(null, new FacesMessage("Clicked node: " + this.getNodeData()));
    }

    public boolean isShowCustomClasses() {
        return this.showCustomClasses;
    }

    public void setShowCustomClasses(boolean showCustomClasses) {
        this.showCustomClasses = showCustomClasses;
    }

    public void behaviorToggleListener(AjaxBehaviorEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.addMessage(null, new FacesMessage("Toggle node: " + this.getNodeData() + ", source is: " + event.getSource()));
    }

    public void behaviorSelectionChangeListener(AjaxBehaviorEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        facesContext.addMessage(event.getComponent().getClientId(facesContext), new FacesMessage("Selection changed, source is: " + event.getSource()));
    }

    public void processSelectionChange(TreeSelectionChangeEvent event) {
        new SelectionChangeHandler(true).processSelectionChange(event);
    }

    public void processToggle(TreeToggleEvent event) {
        new ToggleHandler(true).processToggle(event);
    }

    public String getToggleNodeEvent() {
        return this.toggleNodeEvent;
    }

    public void setToggleNodeEvent(String toggleNodeEvent) {
        this.toggleNodeEvent = toggleNodeEvent;
    }

    public String getExecuteTestText() {
        return this.executeTestText;
    }

    public void setExecuteTestText(String executeTestText) {
        this.executeTestText = executeTestText;
    }

    public String getCurrentTimeAsString() {
        return DateFormat.getTimeInstance().format(new Date());
    }

    static /* synthetic */ AbstractTree access$000(FacesEvent x0) {
        return TreeBean.getTree((FacesEvent)x0);
    }

    static /* synthetic */ FacesMessage access$100(FacesEvent x0, boolean x1) {
        return TreeBean.createEventMessage((FacesEvent)x0, (boolean)x1);
    }
}

