/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.richfaces.demo.Person;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ManagedBean(eager=true)
@ApplicationScoped
public class PersistenceService {
    private static final Logger LOGGER = Logger.getLogger(PersistenceService.class.getName());
    private EntityManagerFactory entityManagerFactory;

    public EntityManager getEntityManager() {
        Map attributes = FacesContext.getCurrentInstance().getAttributes();
        EntityManager manager = (EntityManager)attributes.get(PersistenceService.class);
        if (manager == null) {
            manager = this.entityManagerFactory.createEntityManager();
            attributes.put(PersistenceService.class, manager);
            manager.getTransaction().begin();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeEntityManager() {
        Map attributes = FacesContext.getCurrentInstance().getAttributes();
        EntityManager entityManager = (EntityManager)attributes.remove(PersistenceService.class);
        if (entityManager != null) {
            try {
                entityManager.getTransaction().commit();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                try {
                    entityManager.getTransaction().rollback();
                }
                catch (Exception e1) {
                    LOGGER.log(Level.SEVERE, e1.getMessage(), e1);
                }
            }
            finally {
                entityManager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        this.entityManagerFactory = Persistence.createEntityManagerFactory((String)"iterationDemo", (Map)new Properties());
        EntityManager em = this.entityManagerFactory.createEntityManager();
        EntityTransaction transaction = em.getTransaction();
        try {
            transaction.begin();
            for (Person person : this.parseTestData()) {
                em.persist((Object)person);
            }
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            e.printStackTrace();
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Person> parseTestData() throws Exception {
        InputStream dataStream = null;
        try {
            dataStream = PersistenceService.class.getResourceAsStream("data.xml");
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element node = documentBuilder.parse(dataStream).getDocumentElement();
            ArrayList persons = Lists.newArrayList();
            for (Node personNode = node.getFirstChild(); personNode != null; personNode = personNode.getNextSibling()) {
                if (personNode.getNodeType() != 1) continue;
                Person person = new Person();
                persons.add(person);
                for (Node personDataNode = personNode.getFirstChild(); personDataNode != null; personDataNode = personDataNode.getNextSibling()) {
                    if (personDataNode.getNodeType() != 1) continue;
                    String nodeName = personDataNode.getNodeName();
                    String text = personDataNode.getTextContent();
                    if ("name".equals(nodeName)) {
                        person.setName(text);
                        continue;
                    }
                    if ("surname".equals(nodeName)) {
                        person.setSurname(text);
                        continue;
                    }
                    if (!"email".equals(nodeName)) continue;
                    person.setEmail(text);
                }
            }
            ArrayList arrayList = persons;
            return arrayList;
        }
        finally {
            Closeables.closeQuietly((Closeable)dataStream);
        }
    }

    @PreDestroy
    public void destroy() {
        this.entityManagerFactory.close();
        this.entityManagerFactory = null;
    }
}

