/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.util.HashSet;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.remoting.impl.netty.NettyAcceptorFactory;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServers;
import org.hornetq.jms.server.JMSServerManager;
import org.hornetq.jms.server.config.ConnectionFactoryConfiguration;
import org.hornetq.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.hornetq.jms.server.impl.JMSServerManagerImpl;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.push.PushContextFactory;

public class HornetQInitializer
implements SystemEventListener {
    private JMSServerManager serverManager;

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PostConstructApplicationEvent) {
            try {
                this.startHornetQ();
            }
            catch (Exception e) {
                throw new AbortProcessingException((Throwable)e);
            }
            ((PushContextFactory)ServiceTracker.getService(PushContextFactory.class)).getPushContext();
            Application application = FacesContext.getCurrentInstance().getApplication();
            application.subscribeToEvent(PreDestroyApplicationEvent.class, (SystemEventListener)this);
        } else {
            try {
                this.stopHornetQ();
            }
            catch (Exception e) {
                throw new AbortProcessingException((Throwable)e);
            }
        }
    }

    private void stopHornetQ() throws Exception {
        this.serverManager.stop();
        this.serverManager = null;
    }

    private void startHornetQ() throws Exception {
        ConfigurationImpl configuration = new ConfigurationImpl();
        configuration.setPersistenceEnabled(false);
        configuration.setSecurityEnabled(false);
        TransportConfiguration transpConf = new TransportConfiguration(NettyAcceptorFactory.class.getName());
        HashSet<TransportConfiguration> setTransp = new HashSet<TransportConfiguration>();
        setTransp.add(transpConf);
        configuration.setAcceptorConfigurations(setTransp);
        HornetQServer server = HornetQServers.newHornetQServer((Configuration)configuration);
        this.serverManager = new JMSServerManagerImpl(server);
        InitialContext context = new InitialContext();
        this.serverManager.setContext((Context)context);
        this.serverManager.start();
        ConnectionFactoryConfigurationImpl connectionFactoryConfiguration = new ConnectionFactoryConfigurationImpl("ConnectionFactory", new TransportConfiguration(NettyConnectorFactory.class.getName()), new String[]{null});
        connectionFactoryConfiguration.setUseGlobalPools(false);
        this.serverManager.createConnectionFactory(false, (ConnectionFactoryConfiguration)connectionFactoryConfiguration, new String[]{"ConnectionFactory"});
        this.serverManager.createTopic(false, "chat", new String[]{"/topic/chat"});
        this.serverManager.createTopic(false, "info", new String[]{"/topic/info"});
    }

    public boolean isListenerForSource(Object source) {
        return true;
    }
}

