/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Channel;
import demo.ChannelsBean;
import demo.JMSBean;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.SessionScoped;
import org.richfaces.application.push.MessageException;
import org.richfaces.application.push.TopicKey;
import org.richfaces.application.push.TopicsContext;
import org.richfaces.log.LogFactory;
import org.richfaces.log.Logger;

@ManagedBean
@SessionScoped
public class ChatBean
implements Serializable {
    private static final long serialVersionUID = -6377543444437645751L;
    private static final Logger LOGGER = LogFactory.getLogger(ChatBean.class);
    private String userName;
    private String message;
    private boolean chatJoined;
    private String subchannel;
    @ManagedProperty(value="#{channelsBean}")
    private ChannelsBean channelsBean;
    @ManagedProperty(value="#{jmsBean}")
    private JMSBean jmsBean;

    private TopicsContext lookupTopicsContext() {
        return TopicsContext.lookup();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    private void sendJMSMessage(TopicKey key, String text) {
        this.jmsBean.publish(key, (Serializable)((Object)text));
    }

    private void sendMessage(TopicKey key, String text) {
        this.sendJMSMessage(key, text);
    }

    private void sendSimpleMessage(TopicKey key, String text) {
        try {
            this.lookupTopicsContext().publish(key, (Object)text);
        }
        catch (MessageException e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    private void publishStateChangeMessage(String name, String action) {
        this.sendMessage(new TopicKey("chat", name), MessageFormat.format("*** {0} {1} chat in {2,time,medium}", this.userName, action, new Date()));
    }

    public void joinChat() {
        if (!this.chatJoined) {
            if (this.userName == null) {
                throw new NullPointerException("username");
            }
            this.chatJoined = true;
            for (Channel subchannel : this.channelsBean.getChannels()) {
                this.publishStateChangeMessage(subchannel.getName(), "joined");
            }
        }
    }

    public void handleStateChange(Channel channel) {
        String action = channel.isRendered() ? "joined" : "left";
        this.publishStateChangeMessage(channel.getName(), action);
    }

    public void say() {
        this.sendMessage(new TopicKey("chat", this.subchannel), MessageFormat.format("{0,time,medium} {1}: {2}", new Date(), this.userName, this.message));
    }

    public String getSubchannel() {
        return this.subchannel;
    }

    public void setSubchannel(String subchannel) {
        this.subchannel = subchannel;
    }

    public void setChannelsBean(ChannelsBean channelsBean) {
        this.channelsBean = channelsBean;
    }

    public void setJmsBean(JMSBean jmsBean) {
        this.jmsBean = jmsBean;
    }
}

