/*
 * Decompiled with CFR 0.152.
 */
package demo;

import com.google.common.base.Strings;
import demo.JMSBean;
import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.configuration.ConfigurationService;
import org.richfaces.application.push.TopicKey;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

/*
 * Exception performing whole class analysis ignored.
 */
@ManagedBean(name="jmsBean")
@ApplicationScoped
public class JMSBean {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final PublishTask SHUTDOWN_TASK = new PublishTask(null, null);
    private Connection connection;
    private Thread workerThread;
    private BlockingQueue<PublishTask> tasks = new LinkedBlockingQueue();

    private static String getConnectionFactory(FacesContext facesContext, ConfigurationService configurationService) {
        return JMSBean.getFirstNonEmptyConfgirutationValue((FacesContext)facesContext, (ConfigurationService)configurationService, (Enum[])new Enum[]{CoreConfiguration.PushPropertiesItems.pushPropertiesJMSConnectionFactory, CoreConfiguration.Items.pushJMSConnectionFactory});
    }

    private static String getTopicsNamespace(FacesContext facesContext, ConfigurationService configurationService) {
        return JMSBean.getFirstNonEmptyConfgirutationValue((FacesContext)facesContext, (ConfigurationService)configurationService, (Enum[])new Enum[]{CoreConfiguration.PushPropertiesItems.pushPropertiesJMSTopicsNamespace, CoreConfiguration.Items.pushJMSTopicsNamespace});
    }

    private static String getJMSPassword(FacesContext facesContext, ConfigurationService configurationService) {
        return JMSBean.getFirstNonEmptyConfgirutationValue((FacesContext)facesContext, (ConfigurationService)configurationService, (Enum[])new Enum[]{CoreConfiguration.PushPropertiesItems.pushPropertiesJMSConnectionPassword, CoreConfiguration.Items.pushJMSConnectionPasswordEnvRef, CoreConfiguration.Items.pushJMSConnectionPassword});
    }

    private static String getJMSUserName(FacesContext facesContext, ConfigurationService configurationService) {
        return JMSBean.getFirstNonEmptyConfgirutationValue((FacesContext)facesContext, (ConfigurationService)configurationService, (Enum[])new Enum[]{CoreConfiguration.PushPropertiesItems.pushPropertiesJMSConnectionUsername, CoreConfiguration.Items.pushJMSConnectionUsernameEnvRef, CoreConfiguration.Items.pushJMSConnectionUsername});
    }

    private static Name appendToName(Name name, String comp) throws NamingException {
        Name clonedName = (Name)name.clone();
        return clonedName.add(comp);
    }

    private static String getFirstNonEmptyConfgirutationValue(FacesContext facesContext, ConfigurationService service, Enum<?> ... keys) {
        for (Enum<?> key : keys) {
            String value = service.getStringValue(facesContext, key);
            if (Strings.isNullOrEmpty((String)value)) continue;
            return value;
        }
        return "";
    }

    private Connection createConnection() throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ConfigurationService configurationService = (ConfigurationService)ServiceTracker.getService(ConfigurationService.class);
        InitialContext initialContext = new InitialContext();
        NameParser nameParser = initialContext.getNameParser("");
        Name cnfName = nameParser.parse(JMSBean.getConnectionFactory((FacesContext)facesContext, (ConfigurationService)configurationService));
        ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup(cnfName);
        return connectionFactory.createConnection(JMSBean.getJMSUserName((FacesContext)facesContext, (ConfigurationService)configurationService), JMSBean.getJMSPassword((FacesContext)facesContext, (ConfigurationService)configurationService));
    }

    public void publish(TopicKey topicKey, Serializable message) {
        this.tasks.add(new PublishTask(topicKey, message));
    }

    @PostConstruct
    public void initialize() {
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ConfigurationService configurationService = (ConfigurationService)ServiceTracker.getService(ConfigurationService.class);
            String topicsNamespaceString = JMSBean.getTopicsNamespace((FacesContext)facesContext, (ConfigurationService)configurationService);
            this.connection = this.createConnection();
            this.connection.start();
            this.workerThread = new Thread((Runnable)new PublishRunnable(this, topicsNamespaceString, null));
            this.workerThread.setDaemon(true);
            this.workerThread.start();
        }
        catch (Exception e) {
            LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.tasks.add(SHUTDOWN_TASK);
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                LOGGER.error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }

    static /* synthetic */ Connection access$000(JMSBean x0) {
        return x0.connection;
    }

    static /* synthetic */ BlockingQueue access$100(JMSBean x0) {
        return x0.tasks;
    }

    static /* synthetic */ PublishTask access$200() {
        return SHUTDOWN_TASK;
    }

    static /* synthetic */ Name access$300(Name x0, String x1) throws NamingException {
        return JMSBean.appendToName((Name)x0, (String)x1);
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }
}

