/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.example;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.example.PageDescriptionBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pages {
    public static final String DEFAULT_TITLE_PATTERN = "<h2>(.*)</h2>";
    private static final Pattern JSP_PATTERN = Pattern.compile(".*\\.jspx?");
    private static final Pattern XHTML_PATTERN = Pattern.compile(".*\\.xhtml");
    private Pattern titlePattern = this.compilePattern("<h2>(.*)</h2>");
    private volatile List<PageDescriptionBean> _jspPages;
    private Object jspMutex = new Object();
    private String _path = "/pages";
    private volatile List<PageDescriptionBean> _xhtmlPages;
    private Object xhtmlMutex = new Object();

    public String getPath() {
        return this._path;
    }

    public Pattern compilePattern(String titlePattern) {
        return Pattern.compile(titlePattern, 10);
    }

    public void setPath(String path) {
        this._path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PageDescriptionBean> getJspPages() {
        if (this._jspPages == null && null != this.getExternalContext()) {
            Object object = this.jspMutex;
            synchronized (object) {
                if (this._jspPages == null) {
                    this._jspPages = this.getPagesByPattern(JSP_PATTERN);
                }
            }
        }
        return this._jspPages;
    }

    private ExternalContext getExternalContext() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ExternalContext externalContext = null;
        if (null != facesContext) {
            externalContext = facesContext.getExternalContext();
        }
        return externalContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PageDescriptionBean> getXhtmlPages() {
        if (this._xhtmlPages == null && null != this.getExternalContext()) {
            Object object = this.xhtmlMutex;
            synchronized (object) {
                if (this._xhtmlPages == null) {
                    this._xhtmlPages = this.getPagesByPattern(XHTML_PATTERN);
                }
            }
        }
        return this._xhtmlPages;
    }

    private List<PageDescriptionBean> getPagesByPattern(Pattern pattern) {
        ArrayList<PageDescriptionBean> jspPages = new ArrayList<PageDescriptionBean>();
        Set resourcePaths = this.getExternalContext().getResourcePaths(this.getPath());
        for (String page : resourcePaths) {
            if (!pattern.matcher(page).matches()) continue;
            PageDescriptionBean pageBean = new PageDescriptionBean();
            pageBean.setPath(page);
            InputStream pageInputStream = this.getExternalContext().getResourceAsStream(page);
            if (null != pageInputStream) {
                byte[] head = new byte[1024];
                try {
                    int readed = pageInputStream.read(head);
                    String headString = new String(head, 0, readed);
                    Matcher titleMatcher = this.titlePattern.matcher(headString);
                    if (titleMatcher.find() && titleMatcher.group(1).length() > 0) {
                        pageBean.setTitle(titleMatcher.group(1));
                    } else {
                        pageBean.setTitle(page);
                    }
                }
                catch (IOException e) {
                    throw new FacesException("can't read directory content", (Throwable)e);
                }
                finally {
                    try {
                        pageInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            jspPages.add(pageBean);
        }
        Collections.sort(jspPages);
        return jspPages;
    }

    public void setTitlePattern(String titlePattern) {
        this.titlePattern = this.compilePattern(titlePattern);
    }

    public String getTitlePattern() {
        return this.titlePattern.toString();
    }
}

