/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.example;

import java.text.MessageFormat;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.richfaces.log.LogFactory;
import org.richfaces.log.Logger;

public class PhaseTracker
implements PhaseListener {
    private static final long serialVersionUID = 6358081870120864332L;
    private Logger logger = LogFactory.getLogger(PhaseTracker.class);
    private ThreadLocal<Long> phaseTimer = new ThreadLocal();

    public void afterPhase(PhaseEvent event) {
        Long phaseStartTime = (Long)this.phaseTimer.get();
        long measuredTime = 0L;
        if (phaseStartTime != null) {
            measuredTime = System.currentTimeMillis() - phaseStartTime;
        }
        this.logger.debug((CharSequence)MessageFormat.format("Phase {0} completed by {1}ms", event.getPhaseId(), measuredTime));
        this.phaseTimer.set(null);
    }

    public void beforePhase(PhaseEvent event) {
        this.logger.debug((CharSequence)MessageFormat.format("Phase {0} started", event.getPhaseId()));
        this.phaseTimer.set(System.currentTimeMillis());
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

