/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.example;

import java.util.ArrayList;
import java.util.List;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import org.richfaces.example.MaxBean;
import org.richfaces.example.MinBean;
import org.richfaces.example.MinMaxBean;
import org.richfaces.example.NotEmptyBean;
import org.richfaces.example.NotNullBean;
import org.richfaces.example.PatternBean;
import org.richfaces.example.SizeBean;
import org.richfaces.example.Validable;

@ManagedBean
@SessionScoped
public class DataBean {
    private final List<Validable<?>> beans = new ArrayList(7);

    @Valid
    public List<Validable<?>> getBeans() {
        return this.beans;
    }

    public DataBean() {
        this.beans.add(new NotNullBean());
        this.beans.add(new NotEmptyBean());
        this.beans.add(new SizeBean());
        this.beans.add(new MinBean());
        this.beans.add(new MaxBean());
        this.beans.add(new MinMaxBean());
        this.beans.add(new PatternBean());
    }

    @Max(value=20L, message="Total value should be less then 20")
    public int getTotal() {
        int total = 0;
        for (Validable bean : this.beans) {
            Object value = bean.getValue();
            if (!(value instanceof Integer)) continue;
            Integer intValue = (Integer)value;
            total += intValue.intValue();
        }
        return total;
    }
}

