/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.ServletResponse;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.portlet.application.ComponentsLoader;
import org.ajax4jsf.portlet.application.ComponentsLoaderImpl;
import org.ajax4jsf.portlet.application.PortletStateHolder;
import org.ajax4jsf.portlet.context.AbstractExternalContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxFacesPortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog((Class)(class$org$ajax4jsf$portlet$AjaxFacesPortlet == null ? (class$org$ajax4jsf$portlet$AjaxFacesPortlet = AjaxFacesPortlet.class$("org.ajax4jsf.portlet.AjaxFacesPortlet")) : class$org$ajax4jsf$portlet$AjaxFacesPortlet));
    public static final String PORTLET_CONFIG = "javax.portlet.PortletConfig";
    private Lifecycle lifecycle;
    private FacesContextFactory facesContextFactory;
    private ComponentsLoader componentLoader;
    static /* synthetic */ Class class$org$ajax4jsf$portlet$AjaxFacesPortlet;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Start portlet initialisation for " + config.getPortletName()));
            }
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = config.getPortletContext().getInitParameter("javax.faces.LIFECYCLE_ID");
            if (null == lifecycleId) {
                lifecycleId = "DEFAULT";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create instance of a JSF lifecycle " + lifecycleId));
            }
            this.lifecycle = factory.getLifecycle(lifecycleId);
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        catch (FacesException e) {
            throw new PortletException("Initialization error", (Throwable)e);
        }
        super.init(config);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Done portlet initialisation for " + config.getPortletName()));
        }
        this.componentLoader = new ComponentsLoaderImpl();
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy portlet " + this.getPortletConfig().getPortletName()));
        }
        this.lifecycle = null;
        this.facesContextFactory = null;
        super.destroy();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process action in portlet " + this.getPortletConfig().getPortletName() + " for mode " + request.getPortletMode()));
        }
        FacesContext facesContext = this.getFacesContext((PortletRequest)request, (PortletResponse)response);
        try {
            this.execute(facesContext);
        }
        catch (Exception e) {
            log.error((Object)"Error processing execute lifecycle", (Throwable)e);
            throw new PortletException("Error processing execute lifecycle ", (Throwable)e);
        }
        finally {
            facesContext.release();
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process do view in portlet " + this.getPortletConfig().getPortletName()));
        }
        FacesContext facesContext = this.getFacesContext((PortletRequest)request, (PortletResponse)response);
        try {
            String encoding;
            String contenttype = request.getResponseContentType();
            if (contenttype == null) {
                contenttype = "text/html";
            }
            if ((encoding = response.getCharacterEncoding()) == null) {
                encoding = "UTF-8";
            }
            response.setContentType(contenttype);
            PrintWriter writer = response.getWriter();
            String namespace = response.getNamespace();
            writer.println("<div id='" + namespace + "'>");
            AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
            ajaxContext.getCommonAjaxParameters().put("org.ajax4jsf.portlet.ACTION_URL", response.createActionURL().toString());
            ajaxContext.getCommonAjaxParameters().put(AbstractExternalContext.PORTLET_MODE_PARAMETER, request.getPortletMode().toString());
            ajaxContext.getCommonAjaxParameters().put("org.ajax4jsf.portlet.NAMESPACE", namespace);
            this.render(facesContext);
            writer.println("</div>");
            PortletSession portletSession = request.getPortletSession(true);
            portletSession.setAttribute("org.ajax4jsf.portlet.NAMESPACE", (Object)namespace);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finish rendering portlet for namespace " + namespace));
            }
            response.setProperty("portlet.expiration-cache", "0");
        }
        catch (Exception e) {
            log.error((Object)"Error processing execute lifecycle", (Throwable)e);
            throw new PortletException("Error processing execute lifecycle ", (Throwable)e);
        }
        finally {
            facesContext.release();
        }
    }

    protected void doEdit(RenderRequest arg0, RenderResponse arg1) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process do edit in portlet " + this.getPortletConfig().getPortletName()));
        }
    }

    protected void doHelp(RenderRequest arg0, RenderResponse arg1) throws PortletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Process do help in portlet " + this.getPortletConfig().getPortletName()));
        }
    }

    protected Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    protected FacesContext getFacesContext(PortletRequest request, PortletResponse response) {
        FacesContext facesContext = this.facesContextFactory.getFacesContext((Object)this.getPortletConfig().getPortletContext(), (Object)request, (Object)response, this.getLifecycle());
        facesContext.getExternalContext().getRequestMap().put(PORTLET_CONFIG, this.getPortletConfig());
        return facesContext;
    }

    protected void execute(FacesContext context) throws FacesException {
        this.getLifecycle().execute(context);
    }

    protected void render(FacesContext context) throws FacesException {
        this.getLifecycle().render(context);
    }

    protected void setViewId(FacesContext context) {
        PortletStateHolder portletStateHolder = PortletStateHolder.getInstance(context);
        String viewId = portletStateHolder.getViewId(context);
        context.getExternalContext().getRequestMap().put("org.ajax4jsf.portlet.VIEWID", viewId);
        UIViewRoot viewRoot = context.getViewRoot();
        if (null != viewRoot) {
            viewRoot.setViewId(viewId);
        }
    }

    public static String getPortletNamespace(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Object response = externalContext.getResponse();
        String namespace = null;
        if (response instanceof RenderResponse) {
            namespace = ((RenderResponse)response).getNamespace();
        } else if (response instanceof ServletResponse) {
            namespace = (String)externalContext.getRequestParameterMap().get("org.ajax4jsf.portlet.NAMESPACE");
        } else {
            throw new IllegalStateException("portlet Namespace not availible at this phase");
        }
        return namespace;
    }

    public static PortletMode getPortletMode(FacesContext facesContext) {
        String modeName;
        ExternalContext externalContext = facesContext.getExternalContext();
        Object request = externalContext.getRequest();
        PortletMode mode = null;
        if (request instanceof PortletRequest) {
            mode = ((PortletRequest)request).getPortletMode();
        } else if (null != externalContext.getRequestParameterMap().get(AbstractExternalContext.PORTLET_MODE_PARAMETER) && null != (modeName = (String)externalContext.getRequestParameterMap().get(AbstractExternalContext.PORTLET_MODE_PARAMETER))) {
            mode = new PortletMode(modeName);
        }
        return mode;
    }

    public ComponentsLoader getComponentLoader() {
        return this.componentLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

