/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.portlet;

import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.portlet.AjaxFacesPortlet;
import org.ajax4jsf.portlet.context.AbstractExternalContext;
import org.ajax4jsf.webapp.WebXml;

public class PortletAjaxContext
extends AjaxContextImpl {
    public String getAjaxActionURL(FacesContext context) {
        if (null == context) {
            throw new NullPointerException("Faces context for build AJAX Action URL is null");
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (null == viewRoot) {
            throw new NullPointerException("Faces view tree for build AJAX Action URL is null");
        }
        String viewId = viewRoot.getViewId();
        if (null == viewId) {
            throw new NullPointerException("View id for build AJAX Action URL is null");
        }
        if (!viewId.startsWith("/")) {
            throw new IllegalArgumentException("Illegal view Id for build AJAX Action URL: " + viewId);
        }
        ExternalContext externalContext = context.getExternalContext();
        WebXml webXml = (WebXml)externalContext.getApplicationMap().get(WebXml.CONTEXT_ATTRIBUTE);
        if (null == webXml) {
            throw new NullPointerException("Ajax Filter not properly configured for web application");
        }
        StringBuffer actionUrl = new StringBuffer(externalContext.getRequestContextPath());
        if (webXml.isPrefixMapping()) {
            String facesFilterPrefix = webXml.getFacesFilterPrefix();
            if (facesFilterPrefix.endsWith("/")) {
                facesFilterPrefix = facesFilterPrefix.substring(0, facesFilterPrefix.length() - 1);
            }
            actionUrl.append(facesFilterPrefix).append(viewId);
        } else {
            int dot = viewId.lastIndexOf(46);
            if (dot < 0) {
                actionUrl.append(viewId).append(webXml.getFacesFilterSuffix());
            } else {
                actionUrl.append(viewId.substring(0, dot)).append(webXml.getFacesFilterSuffix());
            }
        }
        return externalContext.encodeActionURL(actionUrl.toString());
    }

    public Map getCommonAjaxParameters() {
        String actionUrl;
        Map map = super.getCommonAjaxParameters();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String namespace = AjaxFacesPortlet.getPortletNamespace(facesContext);
        if (null != namespace) {
            map.put("org.ajax4jsf.portlet.NAMESPACE", namespace);
        }
        if (null != (actionUrl = (String)facesContext.getExternalContext().getRequestParameterMap().get("org.ajax4jsf.portlet.ACTION_URL"))) {
            map.put("org.ajax4jsf.portlet.ACTION_URL", actionUrl);
        }
        String portletMode = (String)facesContext.getExternalContext().getRequestParameterMap().get(AbstractExternalContext.PORTLET_MODE_PARAMETER);
        if (null != actionUrl) {
            map.put(AbstractExternalContext.PORTLET_MODE_PARAMETER, portletMode);
        }
        return map;
    }
}

