/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.portlet.context;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ajax4jsf.portlet.context.EnumerationIterator;

abstract class ContextMap
extends AbstractMap {
    private volatile transient Set keySet;

    ContextMap() {
    }

    public Set entrySet() {
        HashSet<Entry> entries = new HashSet<Entry>();
        Enumeration e = this.getEnumeration();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (!this.isValidParameter(paramName)) continue;
            entries.add(new Entry(paramName, this.get(paramName)));
        }
        return entries;
    }

    protected boolean isValidParameter(String paramName) {
        return true;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return new EnumerationIterator(ContextMap.this.getEnumeration());
                }

                public int size() {
                    Enumeration enumeration = ContextMap.this.getEnumeration();
                    int size = 0;
                    while (enumeration.hasMoreElements()) {
                        ++size;
                    }
                    return size;
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        return super.values();
    }

    protected abstract Enumeration getEnumeration();

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ContextMap)) {
            return false;
        }
        return super.equals(obj);
    }

    static class Entry
    implements Map.Entry {
        private final Object key;
        private final Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry input = (Map.Entry)obj;
            Object inputKey = input.getKey();
            Object inputValue = input.getValue();
            return (inputKey == this.key || inputKey != null && inputKey.equals(this.key)) && (inputValue == this.value || inputValue != null && inputValue.equals(this.value));
        }
    }
}

