/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.portlet.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.ajax4jsf.portlet.context.ELContextImpl;

public class FacesContextImpl
extends FacesContext {
    private boolean released = true;
    private boolean renderResponse;
    private boolean responseComplete;
    private Application application;
    private UIViewRoot viewRoot;
    private Map messages;
    private ExternalContext externalContext;
    private Lifecycle lifecycle;
    private ResponseWriter responseWriter;
    private ResponseStream responseStream;
    private ELContext elContext;
    static /* synthetic */ Class class$javax$faces$context$FacesContext;

    public FacesContextImpl(ExternalContext externalContext, Lifecycle lifecycle) {
        FacesContext.setCurrentInstance((FacesContext)this);
        this.externalContext = externalContext;
        this.lifecycle = lifecycle;
        this.released = false;
    }

    public Lifecycle getLifecycle() {
        this.checkReleased();
        return this.lifecycle;
    }

    public ELContext getELContext() {
        this.checkReleased();
        if (this.elContext == null) {
            Application application = this.getApplication();
            this.elContext = new ELContextImpl(application.getELResolver());
            this.elContext.putContext(class$javax$faces$context$FacesContext == null ? (class$javax$faces$context$FacesContext = FacesContextImpl.class$("javax.faces.context.FacesContext")) : class$javax$faces$context$FacesContext, (Object)this);
            UIViewRoot root = this.getViewRoot();
            if (null != root) {
                this.elContext.setLocale(root.getLocale());
            }
        }
        return this.elContext;
    }

    public ExternalContext getExternalContext() {
        this.checkReleased();
        return this.externalContext;
    }

    public ResponseStream getResponseStream() {
        this.checkReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.checkReleased();
        this.responseStream = responseStream;
    }

    public ResponseWriter getResponseWriter() {
        this.checkReleased();
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.checkReleased();
        this.responseWriter = responseWriter;
    }

    public void release() {
        this.released = true;
        FacesContext.setCurrentInstance(null);
        this.lifecycle = null;
        this.externalContext = null;
        this.responseWriter = null;
        this.application = null;
        this.viewRoot = null;
        this.messages = null;
        this.responseWriter = null;
    }

    public Application getApplication() {
        this.checkReleased();
        if (this.application == null) {
            ApplicationFactory aFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            this.application = aFactory.getApplication();
        }
        return this.application;
    }

    public Iterator getClientIdsWithMessages() {
        this.checkReleased();
        if (this.messages == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.messages.keySet().iterator();
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.checkReleased();
        FacesMessage.Severity max = null;
        Iterator messages = this.getMessages();
        while (messages.hasNext()) {
            FacesMessage msg = (FacesMessage)messages.next();
            FacesMessage.Severity severity = msg.getSeverity();
            if (null != max && max.getOrdinal() >= severity.getOrdinal()) continue;
            max = severity;
        }
        return max;
    }

    public Iterator getMessages() {
        this.checkReleased();
        if (this.messages == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList messages = new ArrayList();
        Iterator i = this.messages.values().iterator();
        while (i.hasNext()) {
            List list = (List)i.next();
            messages.addAll(list);
        }
        if (messages.size() > 0) {
            return messages.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getMessages(String clientID) {
        List list;
        this.checkReleased();
        if (this.messages != null && (list = (List)this.messages.get(clientID)) != null) {
            return list.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public RenderKit getRenderKit() {
        this.checkReleased();
        UIViewRoot viewRoot = this.getViewRoot();
        if (viewRoot == null) {
            return null;
        }
        String renderKitId = viewRoot.getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return rkFactory.getRenderKit((FacesContext)this, renderKitId);
    }

    public boolean getRenderResponse() {
        this.checkReleased();
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        this.checkReleased();
        return this.responseComplete;
    }

    public UIViewRoot getViewRoot() {
        this.checkReleased();
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        this.checkReleased();
        this.viewRoot = viewRoot;
    }

    public void addMessage(String clientID, FacesMessage message) {
        ArrayList<FacesMessage> list;
        this.checkReleased();
        if (message == null) {
            throw new NullPointerException("Message can't be null");
        }
        if (this.messages == null) {
            this.messages = new HashMap();
        }
        if ((list = (ArrayList<FacesMessage>)this.messages.get(clientID)) == null) {
            list = new ArrayList<FacesMessage>();
            this.messages.put(clientID, list);
        }
        list.add(message);
    }

    public void renderResponse() {
        this.checkReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.checkReleased();
        this.responseComplete = true;
    }

    private void checkReleased() {
        if (this.released) {
            throw new IllegalStateException("Context is released.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

