/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.portlet.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.ajax4jsf.portlet.context.AbstractExternalContext;
import org.ajax4jsf.portlet.context.EnumerationIterator;

public class PortletContextImpl
extends AbstractExternalContext {
    private String namespace;

    public PortletContextImpl(PortletContext context, PortletRequest request, PortletResponse response) {
        super(context, request, response);
    }

    public void setResponseCharacterEncoding(String encoding) {
    }

    public String getResponseCharacterEncoding() {
        PortletResponse portletResponse = this.getPortletResponse();
        if (portletResponse instanceof RenderResponse) {
            RenderResponse renderResponse = (RenderResponse)portletResponse;
            return renderResponse.getCharacterEncoding();
        }
        return null;
    }

    public String getResponseContentType() {
        PortletResponse portletResponse = this.getPortletResponse();
        if (portletResponse instanceof RenderResponse) {
            RenderResponse renderResponse = (RenderResponse)portletResponse;
            return renderResponse.getContentType();
        }
        return null;
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        PortletRequest portletRequest = this.getPortletRequest();
        if (portletRequest instanceof ActionRequest) {
            try {
                ActionRequest actionRequest = (ActionRequest)portletRequest;
                actionRequest.setCharacterEncoding(encoding);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public String getRequestCharacterEncoding() {
        PortletRequest portletRequest = this.getPortletRequest();
        if (portletRequest instanceof ActionRequest) {
            ActionRequest actionRequest = (ActionRequest)portletRequest;
            return actionRequest.getCharacterEncoding();
        }
        return null;
    }

    public String getRequestContentType() {
        return null;
    }

    private PortletContext getPortletContext() {
        return (PortletContext)this.getContext();
    }

    private PortletRequest getPortletRequest() {
        return (PortletRequest)this.getRequest();
    }

    private PortletResponse getPortletResponse() {
        return (PortletResponse)this.getResponse();
    }

    public String getInitParameter(String name) {
        return this.getPortletContext().getInitParameter(name);
    }

    protected String getNamespace() {
        if (null == this.namespace) {
            if (this.getResponse() instanceof RenderResponse) {
                this.namespace = ((RenderResponse)this.getResponse()).getNamespace();
            } else {
                throw new IllegalStateException("Portlet namespace not availible in processAction phase");
            }
        }
        return this.namespace;
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.getPortletContext().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getPortletContext().getResourceAsStream(path);
    }

    public Set getResourcePaths(String path) {
        return this.getPortletContext().getResourcePaths(path);
    }

    protected Enumeration enumerateRequestParameterNames() {
        return this.getPortletRequest().getParameterNames();
    }

    protected Object getContextAttribute(String name) {
        return this.getPortletContext().getAttribute(name);
    }

    protected Enumeration getContextAttributeNames() {
        return this.getPortletContext().getAttributeNames();
    }

    protected Enumeration getInitParametersNames() {
        return this.getPortletContext().getInitParameterNames();
    }

    protected Object getRequestAttribute(String name) {
        return this.getPortletRequest().getAttribute(name);
    }

    protected Enumeration getRequestAttributeNames() {
        return this.getPortletRequest().getAttributeNames();
    }

    public Map getRequestParameterValuesMap() {
        return this.getPortletRequest().getParameterMap();
    }

    protected Object getRequestParameterValues(String name) {
        return this.getPortletRequest().getParameterValues(name);
    }

    protected Object getRequestHeader(String name) {
        return this.getPortletRequest().getProperty(name);
    }

    protected Enumeration getRequestHeaderNames() {
        return this.getPortletRequest().getPropertyNames();
    }

    protected String[] getRequestHeaderValues(String name) {
        Enumeration properties = this.getPortletRequest().getProperties(name);
        ArrayList values = new ArrayList();
        while (properties.hasMoreElements()) {
            Object value = properties.nextElement();
            values.add(value);
        }
        return values.toArray(AbstractExternalContext.EMPTY_STRING_ARRAY);
    }

    protected Object getRequestParameter(String name) {
        return this.getPortletRequest().getParameter(name);
    }

    protected Object getSessionAttribute(String name) {
        return this.getPortletRequest().getPortletSession(true).getAttribute(name, 2);
    }

    protected Enumeration getSessionAttributeNames() {
        return this.getPortletRequest().getPortletSession(true).getAttributeNames(2);
    }

    protected void removeContextAttribute(String name) {
        this.getPortletContext().removeAttribute(name);
    }

    protected void removeRequestAttribute(String name) {
        this.getPortletRequest().removeAttribute(name);
    }

    protected void removeSessionAttribute(String name) {
        this.getPortletRequest().getPortletSession(true).removeAttribute(name, 2);
    }

    protected void setContextAttribute(String name, Object value) {
        this.getPortletContext().setAttribute(name, value);
    }

    protected void setRequestAttribute(String name, Object value) {
        this.getPortletRequest().setAttribute(name, value);
    }

    protected void setSessionAttribute(String name, Object value) {
        this.getPortletRequest().getPortletSession(true).setAttribute(name, value, 2);
    }

    public void dispatch(String path) throws IOException {
        if (null == path) {
            throw new NullPointerException("Path to new view is null");
        }
        if (!(this.getRequest() instanceof RenderRequest) || !(this.getResponse() instanceof RenderResponse)) {
            throw new IllegalStateException("Dispatch to new view not at render phase");
        }
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(path);
        if (null == dispatcher) {
            throw new IllegalStateException("Dispatcher for render request is not created");
        }
        try {
            dispatcher.include((RenderRequest)this.getRequest(), (RenderResponse)this.getResponse());
        }
        catch (PortletException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public String encodeActionURL(String url) {
        if (null == url) {
            throw new NullPointerException();
        }
        return url;
    }

    public String encodeResourceURL(String url) {
        return this.getPortletResponse().encodeURL(url);
    }

    public String getAuthType() {
        return this.getPortletRequest().getAuthType();
    }

    public String getRemoteUser() {
        return this.getPortletRequest().getRemoteUser();
    }

    public String getRequestContextPath() {
        return this.getPortletRequest().getContextPath();
    }

    public Locale getRequestLocale() {
        return this.getPortletRequest().getLocale();
    }

    public Iterator getRequestLocales() {
        return new EnumerationIterator(this.getPortletRequest().getLocales());
    }

    public String getRequestPathInfo() {
        String pathInfo = (String)this.getRequestParameter("org.ajax4jsf.portlet.VIEWID");
        if (null == pathInfo) {
            pathInfo = (String)this.getRequestAttribute("org.ajax4jsf.portlet.VIEWID");
        }
        return pathInfo;
    }

    public String getRequestServletPath() {
        return null;
    }

    public Object getSession(boolean create) {
        return this.getPortletRequest().getPortletSession();
    }

    public Principal getUserPrincipal() {
        return this.getPortletRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getPortletRequest().isUserInRole(role);
    }

    public void log(String message) {
        this.getPortletContext().log(message);
    }

    public void log(String message, Throwable exception) {
        this.getPortletContext().log(message, exception);
    }

    public void redirect(String url) throws IOException {
        if (null == url) {
            throw new NullPointerException("Path to redirect is null");
        }
        if (!(this.getRequest() instanceof ActionRequest) || !(this.getResponse() instanceof ActionResponse)) {
            throw new IllegalStateException("Redirect to new url not at action phase");
        }
        ((ActionResponse)this.getResponse()).sendRedirect(url);
    }
}

