/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.portlet.lifecycle;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LifecyclePhase {
    private static final Log _log = LogFactory.getLog((Class)(class$org$ajax4jsf$portlet$lifecycle$LifecyclePhase == null ? (class$org$ajax4jsf$portlet$lifecycle$LifecyclePhase = LifecyclePhase.class$("org.ajax4jsf.portlet.lifecycle.LifecyclePhase")) : class$org$ajax4jsf$portlet$lifecycle$LifecyclePhase));
    private final Lifecycle _lifecycle;
    static /* synthetic */ Class class$org$ajax4jsf$portlet$lifecycle$LifecyclePhase;

    public LifecyclePhase(Lifecycle lifecycle) {
        this._lifecycle = lifecycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FacesContext context) {
        int listenerToCall;
        PhaseEvent event = new PhaseEvent(context, this.getPhaseId(), this.getLifecycle());
        PhaseListener[] listeners = this.getLifecycle().getPhaseListeners();
        try {
            for (listenerToCall = 0; listenerToCall < listeners.length; ++listenerToCall) {
                PhaseListener listener = listeners[listenerToCall];
                if (!this.isExecutableListener(listener)) continue;
                listener.beforePhase(event);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Error to execute beforePhase " + this.getPhaseId().toString() + " method for listener"), (Throwable)e);
        }
        try {
            this.executePhase(context);
        }
        catch (Exception e) {
            _log.error((Object)("Error execute phase " + this.getPhaseId().toString()));
            if (PhaseId.RENDER_RESPONSE.compareTo((Object)this.getPhaseId()) == 0) {
                throw new FacesException((Throwable)e);
            }
        }
        finally {
            try {
                --listenerToCall;
                while (listenerToCall >= 0) {
                    PhaseListener listener = listeners[listenerToCall];
                    if (this.isExecutableListener(listener)) {
                        listener.afterPhase(event);
                    }
                    --listenerToCall;
                }
            }
            catch (Exception e) {
                _log.error((Object)("Error to execute afterPhase " + this.getPhaseId().toString() + " method for listener"), (Throwable)e);
            }
        }
        if (!context.getRenderResponse() && !context.getResponseComplete()) {
            this.executeNextPhase(context);
        }
    }

    protected abstract void executeNextPhase(FacesContext var1);

    public abstract void executePhase(FacesContext var1);

    protected abstract PhaseId getPhaseId();

    private boolean isExecutableListener(PhaseListener listener) {
        PhaseId phaseId = listener.getPhaseId();
        return 0 == this.getPhaseId().compareTo((Object)phaseId) || 0 == PhaseId.ANY_PHASE.compareTo((Object)phaseId);
    }

    public Lifecycle getLifecycle() {
        return this._lifecycle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

