/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.portlet.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.PortletRequest;
import org.ajax4jsf.portlet.application.PortletStateHolder;
import org.ajax4jsf.portlet.application.PortletViewState;
import org.ajax4jsf.portlet.lifecycle.LifecyclePhase;
import org.ajax4jsf.portlet.lifecycle.RenderResponsePhase;
import org.ajax4jsf.portlet.lifecycle.RestoreViewPhase;

public class PortletLifecycle
extends Lifecycle {
    private final List _phaseListeners = new ArrayList();
    private final LifecyclePhase executePhase = new RestoreViewPhase(this);
    private final LifecyclePhase renderPhase = new RenderResponsePhase(this);
    private PhaseListener[] _phaseListenersArray = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener listener) {
        if (null == listener) {
            throw new NullPointerException("PhaseListener for add to Lifecycle can't be null");
        }
        List list = this._phaseListeners;
        synchronized (list) {
            this._phaseListeners.add(listener);
            this._phaseListenersArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener listener) {
        if (null == listener) {
            throw new NullPointerException("PhaseListener for remove from Lifecycle can't be null");
        }
        List list = this._phaseListeners;
        synchronized (list) {
            this._phaseListeners.remove(listener);
            this._phaseListenersArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PhaseListener[] getPhaseListeners() {
        if (this._phaseListenersArray == null) {
            List list = this._phaseListeners;
            synchronized (list) {
                this._phaseListenersArray = this._phaseListeners.toArray(new PhaseListener[this._phaseListeners.size()]);
            }
        }
        return this._phaseListenersArray;
    }

    public void execute(FacesContext context) throws FacesException {
        this.executePhase.execute(context);
        Object request = context.getExternalContext().getRequest();
        if (request instanceof PortletRequest) {
            context.getApplication().getStateManager().saveSerializedView(context);
        }
        PortletViewState windowState = PortletStateHolder.getInstance(context).getWindowState(context);
        windowState.saveMessages(context);
        HashMap requestScopeBeans = new HashMap();
        Iterator iterator = context.getExternalContext().getRequestMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String paramName = entry.getKey().toString();
            Object bean = entry.getValue();
            if (paramName.contains(".") || !(bean instanceof Serializable)) continue;
            requestScopeBeans.put(paramName, bean);
        }
        if (requestScopeBeans.size() > 0) {
            windowState.setRequestScopeBeans(requestScopeBeans);
        }
    }

    public void render(FacesContext context) throws FacesException {
        Object request = context.getExternalContext().getRequest();
        if (request instanceof PortletRequest) {
            this.executePhase.executePhase(context);
            PortletViewState windowState = PortletStateHolder.getInstance(context).getWindowState(context);
            windowState.restoreMessages(context);
            Map requestScopeBeans = windowState.getRequestScopeBeans();
            if (null != requestScopeBeans) {
                context.getExternalContext().getRequestMap().putAll(requestScopeBeans);
            }
        }
        this.renderPhase.execute(context);
    }
}

