/**
 * 
 */
package org.ajax4jsf.context;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/**
 * This class hold all methods for get application init parameters. Created for
 * single access point to all parameters - simplest for a documentation.
 * 
 * @author asmirnov
 * 
 */
public class ContextInitParameters {

	/**
	 * 
	 */
	private ContextInitParameters() {
		// this is a only static methods for a access to Web app Init
		// parameters. Do not Instantiate !
	}

	public static final String[] SERIALIZE_SERVER_STATE = new String[] {
		"org.ajax4jsf.SERIALIZE_SERVER_STATE", 

		/* detect MyFaces vs. RI */
		"com.sun.faces.serializeServerState",
		"org.apache.myfaces.SERIALIZE_STATE_IN_SESSION"
	};
	
	public static final boolean isSerializeServerState(FacesContext context) {
		return getBoolean(context, SERIALIZE_SERVER_STATE, false);
	}
	
	static int getInteger(FacesContext context, String[] paramNames,
			int defaulValue) {
		String initParameter = getInitParameter(context,paramNames);
		if (null == initParameter) {
			return defaulValue;
		} else {
			try {
				return Integer.parseInt(initParameter);

			} catch (NumberFormatException e) {
				throw new FacesException("Context parameter " + paramNames
						+ " must have integer value");
			}
		}
	}

	static String getString(FacesContext context, String[] paramNames,
			String defaulValue) {
		String initParameter = getInitParameter(context,paramNames);
		if (null == initParameter) {
			return defaulValue;
		} else {
			return initParameter;
		}
	}

	static boolean getBoolean(FacesContext context, String[] paramNames,
			boolean defaulValue) {
		String initParameter = getInitParameter(context,paramNames);
		if (null == initParameter) {
			return defaulValue;
		} else if("true".equalsIgnoreCase(initParameter) || "yes".equalsIgnoreCase(initParameter)) {
			return true;
		} else if("false".equalsIgnoreCase(initParameter) || "no".equalsIgnoreCase(initParameter)) {
			return false;
		} else {
			throw new FacesException("Illegal value ["+initParameter+"] for a init parameter +"+paramNames+", only logical values 'true' or 'false' is allowed");
		}
	}

	static String getInitParameter(FacesContext context,
			String[] paramNames) {
		ExternalContext externalContext = context.getExternalContext();
		String value = null;
		for (int i = 0; i < paramNames.length && null == value; i++) {
			value = externalContext.getInitParameter(paramNames[i]);
		}
		return value;
	}


} 