/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.util.ELUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.skin.SkinImpl;
import org.richfaces.skin.SkinNotFoundException;

public class SkinFactoryImpl
extends SkinFactory {
    public static final String RENDER_KIT_PARAMETER = "org.ajax4jsf.RENDERKIT_DEFINITION";
    private static final String DEFAULT_SKIN_PROPERTIES_RESOURCE = "META-INF/skins/DEFAULT.skin.properties";
    private static final String DEFAULT_CONFIGURATION_RESOURCE = "META-INF/skins/DEFAULT.configuration.properties";
    private static final String DEFAULT_SKIN_NAME = "DEFAULT";
    private static final String[] SKINS_PATHS = new String[]{"META-INF/skins/%s.skin.properties", "%s.skin.properties"};
    private static final String[] DEFAULT_SKIN_PATHS = new String[]{"META-INF/skins/DEFAULT.skin.properties"};
    private static final String[] CONFIGURATIONS_PATHS = new String[]{"META-INF/skins/%s.configuration.properties", "%s.configuration.properties"};
    private static final String[] DEFAULT_CONFIGURATION_PATHS = new String[]{"META-INF/skins/DEFAULT.configuration.properties"};
    private Map skins = Collections.synchronizedMap(new HashMap());
    private Properties defaultSkinProperties = null;
    private String skinName = null;
    private ValueBinding skinBinding = null;
    private String baseSkinName = null;
    private ValueBinding baseSkinBinding = null;
    private static final Log log = LogFactory.getLog((Class)(class$org$richfaces$skin$SkinFactoryImpl == null ? (class$org$richfaces$skin$SkinFactoryImpl = SkinFactoryImpl.class$("org.richfaces.skin.SkinFactoryImpl")) : class$org$richfaces$skin$SkinFactoryImpl));
    private static final String A4J_BASE_SKIN_PARAMETER = "org.ajax4jsf.BASE_SKIN";
    private static final String A4J_SKIN_PARAMETER = "org.ajax4jsf.SKIN";
    static /* synthetic */ Class class$org$richfaces$skin$SkinFactoryImpl;

    protected Skin getSkinByName(Object currentSkinOrName) {
        if (null == currentSkinOrName) {
            throw new SkinNotFoundException(Messages.getMessage((String)"NULL_SKIN_NAME_ERROR"));
        }
        if (currentSkinOrName instanceof Skin) {
            return (Skin)currentSkinOrName;
        }
        String currentSkinName = currentSkinOrName.toString();
        Skin currentSkin = (Skin)this.skins.get(currentSkinName);
        if (currentSkin == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage((String)"CREATE_SKIN_INFO", (Object)currentSkinName));
            }
            currentSkin = this.buildSkin(currentSkinName, this.getDefaultSkinProperties());
            this.skins.put(currentSkinName, currentSkin);
        }
        return currentSkin;
    }

    public Skin getDefaultSkin(FacesContext context) {
        return this.getSkinByName(DEFAULT_SKIN_NAME);
    }

    public Skin getSkin(FacesContext context) {
        Object currentSkinOrName = this.getSkinOrName(context, false);
        return this.getSkinByName(currentSkinOrName);
    }

    public Skin getBaseSkin(FacesContext context) {
        Object currentSkinOrName = this.getSkinOrName(context, true);
        return this.getSkinByName(currentSkinOrName);
    }

    protected Properties getDefaultSkinProperties() {
        if (this.defaultSkinProperties == null) {
            this.defaultSkinProperties = this.loadDefaultProperties(DEFAULT_SKIN_PROPERTIES_RESOURCE);
        }
        return this.defaultSkinProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadDefaultProperties(String path) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Properties defaultProperties = new Properties();
        try {
            Enumeration<URL> properties = loader.getResources(path);
            while (properties.hasMoreElements()) {
                URL url = properties.nextElement();
                InputStream propertyStream = null;
                try {
                    propertyStream = URLToStreamHelper.urlToStream((URL)url);
                    defaultProperties.load(propertyStream);
                }
                catch (IOException e) {
                    log.info((Object)Messages.getMessage((String)"DEFAULT_PROPERTIES_NOT_FOUND_ERROR", (Object)path), (Throwable)e);
                }
                finally {
                    if (null == propertyStream) continue;
                    propertyStream.close();
                }
            }
        }
        catch (IOException e) {
            log.info((Object)Messages.getMessage((String)"DEFAULT_PROPERTIES_NOT_FOUND_ERROR", (Object)path), (Throwable)e);
        }
        return defaultProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getSkinOrName(FacesContext context, boolean useBase) {
        String skin;
        ValueBinding binding;
        SkinFactoryImpl skinFactoryImpl = this;
        synchronized (skinFactoryImpl) {
            if (useBase) {
                binding = this.baseSkinBinding;
                skin = this.baseSkinName;
            } else {
                binding = this.skinBinding;
                skin = this.skinName;
            }
            if (binding == null && skin == null) {
                String currentSkinName = context.getExternalContext().getInitParameter(useBase ? "org.richfaces.BASE_SKIN" : "org.richfaces.SKIN");
                if (null == currentSkinName && null != (currentSkinName = context.getExternalContext().getInitParameter(useBase ? A4J_BASE_SKIN_PARAMETER : A4J_SKIN_PARAMETER))) {
                    log.warn((Object)("Init parameter for a skin name changed to " + (useBase ? "org.richfaces.BASE_SKIN" : "org.richfaces.SKIN")));
                }
                if (currentSkinName == null) {
                    return DEFAULT_SKIN_NAME;
                }
                if (ELUtils.isValueReference(currentSkinName)) {
                    binding = context.getApplication().createValueBinding(currentSkinName);
                } else {
                    skin = currentSkinName;
                }
            }
            if (useBase) {
                this.baseSkinBinding = binding;
                this.baseSkinName = skin;
            } else {
                this.skinBinding = binding;
                this.skinName = skin;
            }
        }
        if (binding != null) {
            return binding.getValue(context);
        }
        return skin;
    }

    protected Skin buildSkin(String name, Properties defaultProperties) throws SkinNotFoundException {
        Map skinParams = this.loadProperties(name, defaultProperties, SKINS_PATHS);
        return new SkinImpl(skinParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadProperties(String name, Properties defaultProperties, String[] paths) throws SkinNotFoundException, FacesException, ReferenceSyntaxException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Properties skinProperties = new Properties(defaultProperties);
        int loadedPropertiesCount = 0;
        for (int i = 0; i < paths.length; ++i) {
            try {
                String skinPropertiesLocation = paths[i].replaceAll("%s", name);
                Enumeration<URL> properties = loader.getResources(skinPropertiesLocation);
                while (properties.hasMoreElements()) {
                    URL url = properties.nextElement();
                    InputStream propertyStream = null;
                    try {
                        propertyStream = URLToStreamHelper.urlToStream((URL)url);
                        skinProperties.load(propertyStream);
                        ++loadedPropertiesCount;
                    }
                    catch (IOException e) {
                        log.warn((Object)Messages.getMessage((String)"SKIN_PROPERTIES_IO_ERROR"), (Throwable)e);
                    }
                    finally {
                        if (null == propertyStream) continue;
                        propertyStream.close();
                    }
                }
                continue;
            }
            catch (IOException e) {
                if (!log.isInfoEnabled()) continue;
                log.info((Object)Messages.getMessage((String)"SKIN_PROPERTIES_IO_ERROR"), (Throwable)e);
            }
        }
        if (loadedPropertiesCount == 0) {
            throw new SkinNotFoundException(Messages.getMessage((String)"SKIN_NOT_FOUND_ERROR", (Object)name));
        }
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Application app = factory.getApplication();
        HashMap<String, Object> skinParams = new HashMap<String, Object>();
        Enumeration<?> e = skinProperties.propertyNames();
        while (e.hasMoreElements()) {
            String propertyName = (String)e.nextElement();
            String property = skinProperties.getProperty(propertyName);
            if (null == property) continue;
            int count = 0;
            while (property.startsWith("&")) {
                if (null == (property = skinProperties.getProperty(property.substring(1)))) {
                    throw new FacesException(Messages.getMessage((String)"SKIN_ILLEGAL_REFERENCE", (Object)propertyName));
                }
                if (count++ <= 1000) continue;
                throw new FacesException(Messages.getMessage((String)"SKIN_CYCLIC_REFERENCE", (Object)propertyName));
            }
            if (ELUtils.isValueReference(property)) {
                skinParams.put(propertyName, app.createValueBinding(property));
                continue;
            }
            skinParams.put(propertyName, property);
        }
        return skinParams;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

