/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.event;

import java.util.Iterator;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.ajax4jsf.application.AjaxStateManager;
import org.ajax4jsf.application.AjaxViewHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InitPhaseListener
implements PhaseListener {
    private volatile boolean removed = false;
    private volatile boolean initialized = false;
    private static final Log log = LogFactory.getLog(InitPhaseListener.class);

    public synchronized void afterPhase(PhaseEvent event) {
        if (!this.removed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Remove init phase listener from factories");
            }
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Iterator iter = factory.getLifecycleIds();
            while (iter.hasNext()) {
                Lifecycle lifecycle = factory.getLifecycle((String)iter.next());
                lifecycle.removePhaseListener((PhaseListener)this);
            }
            this.removed = true;
        }
    }

    public synchronized void beforePhase(PhaseEvent event) {
        if (!this.initialized) {
            ViewHandler viewHandler;
            FacesContext facesContext;
            Application application;
            StateManager stateManager;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Perform additional framework initialization on first request");
            }
            if (!((stateManager = (application = (facesContext = event.getFacesContext()).getApplication()).getStateManager()) instanceof AjaxStateManager)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Set AjaxStateManager on top of chain");
                }
                application.setStateManager((StateManager)new AjaxStateManager(stateManager));
            }
            if (!((viewHandler = application.getViewHandler()) instanceof AjaxViewHandler)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Set AjaxViewHandler on top of chain");
                }
                application.setViewHandler((ViewHandler)new AjaxViewHandler(viewHandler));
            }
            this.initialized = true;
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

