/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.Messages;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceRenderer;

public abstract class BaseResourceRenderer
implements ResourceRenderer {
    public void encode(InternetResource resource, FacesContext context, Object data) throws IOException {
        this.encodeBegin(resource, context, data, Collections.EMPTY_MAP);
        this.encodeEnd(resource, context, data);
    }

    public void encode(InternetResource resource, FacesContext context, Object data, Map attributes) throws IOException {
        this.encodeBegin(resource, context, data, attributes);
        this.encodeEnd(resource, context, data);
    }

    public void encodeBegin(InternetResource resource, FacesContext context, Object data, Map attributes) throws IOException {
        if (null != this.getTag()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement(this.getTag(), null);
            String[][] attrs = this.getCommonAttrs();
            if (null != this.getHrefAttr()) {
                writer.writeAttribute(this.getHrefAttr(), (Object)resource.getUri(context, data), null);
            }
            if (null != attrs) {
                for (int i = 0; i < attrs.length; ++i) {
                    writer.writeAttribute(attrs[i][0], (Object)attrs[i][1], null);
                }
            }
            for (Map.Entry attr : attributes.entrySet()) {
                writer.writeAttribute(attr.getKey().toString(), attr.getValue(), null);
            }
        }
        this.customEncode(resource, context, data);
    }

    public void encodeEnd(InternetResource resource, FacesContext context, Object data) throws IOException {
        if (null != this.getTag()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.endElement(this.getTag());
        }
    }

    protected void customEncode(InternetResource resource, FacesContext context, Object data) throws IOException {
    }

    protected abstract String getTag();

    protected abstract String getHrefAttr();

    protected abstract String[][] getCommonAttrs();

    public int send(InternetResource base, ResourceContext context) throws IOException {
        InputStream in = base.getResourceAsStream(context);
        OutputStream out = context.getOutputStream();
        if (null == in) {
            String message = Messages.getMessage((String)"NO_INPUT_STREAM_ERROR", (Object)base.getKey());
            throw new IOException(message);
        }
        int total = this.sendStream(in, out);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int sendStream(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buffer = new byte[1024];
        try {
            int length = in.read(buffer);
            while (length > 0) {
                out.write(buffer, 0, length);
                total += length;
                length = in.read(buffer);
            }
        }
        finally {
            in.close();
            out.flush();
            out.close();
        }
        return total;
    }

    public boolean requireFacesContext() {
        return false;
    }

    public Object getData(InternetResource base, FacesContext context, Object data) {
        return null;
    }
}

