/**
 * 
 */
package org.ajax4jsf.webapp;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

/**
 * @author Maksim Kaszynski
 *
 */
public class ParserFacade {
	
	private BaseXMLFilter filter;
	
	private FacesContext context;
	
	public static ParserFacade newInstance(FacesContext context) {
		return new ParserFacade(context);
	}
	
	private ParserFacade(FacesContext context) {
		super();
		this.context = context;
		this.filter = BaseXMLFilter.getInstance(context);
	}

	public void parseHtml(Reader input, Writer output) throws IOException {
		UIViewRoot viewRoot = context.getViewRoot();
		HtmlParser parser = filter.getParser(filter.getMimetype(), true, viewRoot.getViewId());
		parser.parseHtml(input, output);
		filter.reuseParser(parser);
	}
	
}
