/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class ContextInitParameters {
    public static final String[] NUMBER_OF_VIEWS_IN_SESSION = new String[]{"com.sun.faces.numberOfViewsInSession"};
    public static final String[] NUMBER_OF_LOGICAL_VIEWS_IN_SESSION = new String[]{"com.sun.faces.numberOfLogicalViews"};
    public static final String HANDLE_VIEW_EXPIRED_ON_CLIENT = "org.ajax4jsf.handleViewExpiredOnClient";

    private ContextInitParameters() {
    }

    public static int getNumbersOfViewsInSession(FacesContext context) {
        return ContextInitParameters.getInteger(context, NUMBER_OF_VIEWS_IN_SESSION, 16);
    }

    public static int getNumbersOfLogicalViews(FacesContext context) {
        return ContextInitParameters.getInteger(context, NUMBER_OF_LOGICAL_VIEWS_IN_SESSION, 16);
    }

    static int getInteger(FacesContext context, String[] paramNames, int defaulValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaulValue;
        }
        try {
            return Integer.parseInt(initParameter);
        }
        catch (NumberFormatException e) {
            throw new FacesException("Context parameter " + paramNames + " must have integer value");
        }
    }

    static String getString(FacesContext context, String[] paramNames, String defaulValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaulValue;
        }
        return initParameter;
    }

    static boolean getBoolean(FacesContext context, String[] paramNames, boolean defaulValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaulValue;
        }
        if ("true".equalsIgnoreCase(initParameter) || "yes".equalsIgnoreCase(initParameter)) {
            return true;
        }
        if ("false".equalsIgnoreCase(initParameter) || "no".equalsIgnoreCase(initParameter)) {
            return false;
        }
        throw new FacesException("Illegal value [" + initParameter + "] for a init parameter +" + paramNames + ", only logical values 'true' or 'false' is allowed");
    }

    static String getInitParameter(FacesContext context, String[] paramNames) {
        ExternalContext externalContext = context.getExternalContext();
        String value = null;
        for (int i = 0; i < paramNames.length && null == value; ++i) {
            value = externalContext.getInitParameter(paramNames[i]);
        }
        return value;
    }
}

