/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.Serializable;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.application.StateHolder;
import org.ajax4jsf.context.ContextInitParameters;
import org.ajax4jsf.util.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxStateHolder
implements Serializable,
StateHolder {
    private static final Log _log = LogFactory.getLog(AjaxStateHolder.class);
    private static final long serialVersionUID = 6414488517358423537L;
    private static final String STATE_HOLDER = AjaxStateHolder.class.getName();
    private final LRUMap<String, LRUMap<String, Object>> views;
    private final int numberOfViews;

    private AjaxStateHolder(int capacity, int numberOfViews) {
        this.views = new LRUMap(capacity);
        this.numberOfViews = numberOfViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StateHolder getInstance(FacesContext context) {
        if (null == context) {
            throw new NullPointerException("FacesContext parameter for get view states object is null");
        }
        ExternalContext externalContext = context.getExternalContext();
        Object session = externalContext.getSession(true);
        Map sessionMap = externalContext.getSessionMap();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Request for a view states holder instance");
        }
        StateHolder instance = null;
        Object object = session;
        synchronized (object) {
            instance = (StateHolder)sessionMap.get(STATE_HOLDER);
            if (null == instance) {
                int numbersOfViewsInSession = ContextInitParameters.getNumbersOfViewsInSession(context);
                int numbersOfLogicalViews = ContextInitParameters.getNumbersOfLogicalViews(context);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No AjaxStateHolder instance in session, create new for hold " + numbersOfViewsInSession + " viewId and " + numbersOfLogicalViews + " logical views for each"));
                }
                instance = new AjaxStateHolder(numbersOfViewsInSession, numbersOfLogicalViews);
                sessionMap.put(STATE_HOLDER, instance);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getState(String viewId, String sequence) {
        if (null == viewId) {
            throw new NullPointerException("viewId parameter for get saved view state is null");
        }
        Object state = null;
        LRUMap<String, LRUMap<String, Object>> lRUMap = this.views;
        synchronized (lRUMap) {
            LRUMap viewVersions = (LRUMap)this.views.get(viewId);
            if (null != viewVersions) {
                if (null != sequence) {
                    state = viewVersions.get(sequence);
                }
                if (null == state) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("No saved view state for sequence " + sequence + ", use most recent"));
                    }
                    state = viewVersions.getMostRecent();
                }
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("No saved view states for viewId " + viewId));
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(String viewId, String sequence, Object state) {
        if (null == viewId) {
            throw new NullPointerException("viewId parameter for  save view state is null");
        }
        if (null == sequence) {
            throw new NullPointerException("sequence parameter for save view state is null");
        }
        if (null != state) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Save new viewState in session for viewId " + viewId + " and sequence " + sequence));
            }
            LRUMap<String, LRUMap<String, Object>> lRUMap = this.views;
            synchronized (lRUMap) {
                LRUMap<String, Object> viewVersions = (LRUMap<String, Object>)this.views.get(viewId);
                if (null == viewVersions) {
                    viewVersions = new LRUMap<String, Object>(this.numberOfViews);
                    this.views.put(viewId, viewVersions);
                }
                viewVersions.put(sequence, state);
            }
        }
    }
}

