/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.ResponseWriterContentHandler;
import org.ajax4jsf.io.SAXResponseWriter;
import org.ajax4jsf.renderkit.HeaderResourceProducer;
import org.ajax4jsf.renderkit.HeaderResourceProducer2;
import org.ajax4jsf.renderkit.ProducerContext;
import org.ajax4jsf.renderkit.ProducerContextImpl;
import org.ajax4jsf.renderkit.UserResourceRenderer;
import org.ajax4jsf.renderkit.UserResourceRenderer2;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBase;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceNotFoundException;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.resource.URIInternetResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.richfaces.skin.SkinNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewResources {
    private String scriptStrategy;
    private String styleStrategy;
    private boolean useStdControlsSkinning;
    private boolean useStdControlsSkinningClasses;
    private HeadResponseWriter componentWriter;
    private HeadResponseWriter userWriter;
    private RenderKit renderKit;
    private Object[] result = null;
    private static final String EXTENDED_SKINNING_ON_NO_SCRIPTS_INFO_KEY = ViewResources.class.getName() + "EXTENDED_SKINNING_ON_NO_SCRIPTS_INFO_KEY";
    private static final InternetResource EXTENDED_SKINNING_ON_RESOURCE = new InternetResourceBase(){
        private final String RESOURCE_KEY = this.getClass().getName();

        @Override
        public void encode(FacesContext context, Object data) throws IOException {
            this.encode(context, data, Collections.EMPTY_MAP);
        }

        @Override
        public void encode(FacesContext context, Object data, Map<String, Object> attributes) throws IOException {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (requestMap.get(this.RESOURCE_KEY) == null) {
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("script", null);
                if (!attributes.containsKey("type")) {
                    writer.writeAttribute("type", (Object)"text/javascript", null);
                }
                for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                    writer.writeAttribute(entry.getKey(), entry.getValue(), null);
                }
                writer.writeText((Object)"window.RICH_FACES_EXTENDED_SKINNING_ON=true;", null);
                writer.endElement("script");
                requestMap.put(this.RESOURCE_KEY, Boolean.TRUE);
            }
        }
    };
    private static final Log log = LogFactory.getLog(ViewResources.class);
    private static final Map<String, Object> EXTENDED_SKINNING = new HashMap<String, Object>(1);
    public static final String SKINNING_STYLES_PATH = "/org/richfaces/renderkit/html/css/";
    private boolean extendedSkinningAllowed;
    private boolean processScripts;
    private boolean processStyles;
    private boolean useSkinning;
    private InternetResourceBuilder resourceBuilder;
    private boolean ajaxRequest;
    private ProducerContext producerContext;
    public static final String COMPONENT_RESOURCE_LINK_CLASS = "component";
    public static final String USER_RESOURCE_LINK_CLASS = "user";

    public void setScriptStrategy(String scriptsStrategy) {
        this.scriptStrategy = scriptsStrategy;
    }

    public void setStyleStrategy(String stylesStrategy) {
        this.styleStrategy = stylesStrategy;
    }

    public void setUseStdControlsSkinning(boolean stdControlsSkinning) {
        this.useStdControlsSkinning = stdControlsSkinning;
    }

    public void setUseStdControlsSkinningClasses(boolean stdControlsSkinningClasses) {
        this.useStdControlsSkinningClasses = stdControlsSkinningClasses;
    }

    public void setExtendedSkinningAllowed(boolean extendedSkinningAllowed) {
        this.extendedSkinningAllowed = extendedSkinningAllowed;
    }

    public Object getHeadEvents() {
        List componentList = this.componentWriter.getEventsList();
        List userList = this.userWriter.getEventsList();
        this.result = new Object[componentList.size() + userList.size()];
        componentList.toArray(this.result);
        System.arraycopy(userList.toArray(), 0, this.result, componentList.size(), userList.size());
        return this.result;
    }

    private void encodeResources(FacesContext context, ResourceRenderer renderer, Set<String> set) throws IOException {
        if (set != null) {
            URIInternetResource resourceImpl = new URIInternetResource();
            for (String uri : set) {
                resourceImpl.setUri(uri);
                renderer.encode((InternetResource)resourceImpl, context, null);
            }
        }
    }

    private boolean encodeSkinningResources(FacesContext context, InternetResourceBuilder resourceBuilder) throws IOException, FacesException {
        String resourceSuffix = null;
        if (this.useStdControlsSkinning) {
            resourceSuffix = this.useStdControlsSkinningClasses ? "_both.xcss" : ".xcss";
        } else if (this.useStdControlsSkinningClasses) {
            resourceSuffix = "_classes.xcss";
        }
        if (resourceSuffix != null) {
            resourceBuilder.createResource((Object)this, SKINNING_STYLES_PATH.concat("basic").concat(resourceSuffix)).encode(context, null);
            if (this.extendedSkinningAllowed) {
                resourceBuilder.createResource((Object)this, SKINNING_STYLES_PATH.concat("extended").concat(resourceSuffix)).encode(context, null, EXTENDED_SKINNING);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processComponent(FacesContext context, UIComponent component) throws IOException, FacesException {
        Renderer renderer = this.getRenderer(context, component);
        if (null != renderer) {
            ResponseWriter oldResponseWriter = context.getResponseWriter();
            try {
                if ((this.processScripts || this.processStyles) && (renderer instanceof HeaderResourceProducer2 || renderer instanceof HeaderResourceProducer)) {
                    context.setResponseWriter((ResponseWriter)this.componentWriter);
                    if (renderer instanceof HeaderResourceProducer2) {
                        HeaderResourceProducer2 producer = (HeaderResourceProducer2)renderer;
                        if (this.producerContext == null) {
                            this.producerContext = new ProducerContextImpl(this.processScripts, this.processStyles);
                        }
                        producer.encodeToHead(context, component, this.producerContext);
                    } else if (renderer instanceof HeaderResourceProducer) {
                        HeaderResourceProducer producer = (HeaderResourceProducer)renderer;
                        if (this.processScripts) {
                            this.encodeResources(context, this.resourceBuilder.getScriptRenderer(), producer.getHeaderScripts(context, component));
                        }
                        if (this.processStyles) {
                            this.encodeResources(context, this.resourceBuilder.getStyleRenderer(), producer.getHeaderStyles(context, component));
                        }
                    }
                } else if (renderer instanceof UserResourceRenderer2) {
                    context.setResponseWriter((ResponseWriter)this.userWriter);
                    UserResourceRenderer2 producer = (UserResourceRenderer2)renderer;
                    producer.encodeToHead(context, component);
                } else if (renderer instanceof UserResourceRenderer) {
                    context.setResponseWriter((ResponseWriter)this.userWriter);
                    UserResourceRenderer producer = (UserResourceRenderer)renderer;
                    this.encodeResources(context, this.resourceBuilder.getScriptRenderer(), producer.getHeaderScripts(context, component));
                    this.encodeResources(context, this.resourceBuilder.getStyleRenderer(), producer.getHeaderStyles(context, component));
                }
            }
            finally {
                context.setResponseWriter(oldResponseWriter);
            }
        }
    }

    private Renderer getRenderer(FacesContext context, UIComponent comp) {
        String rendererType = comp.getRendererType();
        if (rendererType != null) {
            return this.renderKit.getRenderer(comp.getFamily(), rendererType);
        }
        return null;
    }

    protected void traverse(FacesContext context, UIComponent component) throws IOException, FacesException {
        if (component != null) {
            this.processComponent(context, component);
            if (component.getChildCount() > 0) {
                for (UIComponent child : component.getChildren()) {
                    this.traverse(context, child);
                }
            }
            if (component.getFacetCount() > 0) {
                for (UIComponent child : component.getFacets().values()) {
                    this.traverse(context, child);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processHeadResources(FacesContext context) throws FacesException {
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.renderKit = rkFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        boolean scriptsOff = false;
        this.processStyles = true;
        this.processScripts = true;
        this.useSkinning = false;
        this.ajaxRequest = AjaxContext.getCurrentInstance((FacesContext)context).isAjaxRequest(context);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Process component tree for collect used scripts and styles");
        }
        String skinStyleSheetUri = null;
        String skinExtendedStyleSheetUri = null;
        Skin skin = null;
        try {
            skin = SkinFactory.getInstance().getSkin(context);
            if ("false".equals(skin.getParameter(context, "loadStyleSheets"))) {
                this.processStyles = false;
            }
            skinStyleSheetUri = (String)skin.getParameter(context, "generalStyleSheet");
            skinExtendedStyleSheetUri = (String)skin.getParameter(context, "extendedStyleSheet");
        }
        catch (SkinNotFoundException e) {
            log.warn((Object)"Current Skin is not found", (Throwable)e);
        }
        this.resourceBuilder = InternetResourceBuilder.getInstance();
        ResponseWriter oldResponseWriter = context.getResponseWriter();
        this.componentWriter = new HeadResponseWriter(COMPONENT_RESOURCE_LINK_CLASS);
        this.userWriter = new HeadResponseWriter(USER_RESOURCE_LINK_CLASS);
        try {
            URIInternetResource resourceImpl;
            String resourceURL;
            block39: {
                this.componentWriter.startDocument();
                this.userWriter.startDocument();
                context.setResponseWriter((ResponseWriter)this.componentWriter);
                if (null != this.scriptStrategy) {
                    if ("NONE".equals(this.scriptStrategy)) {
                        scriptsOff = true;
                        this.processScripts = false;
                    } else if ("ALL".equals(this.scriptStrategy)) {
                        this.processScripts = false;
                        if (!this.ajaxRequest) {
                            try {
                                this.resourceBuilder.createResource((Object)this, "/org/ajax4jsf/framework.pack.js").encode(context, null);
                                this.resourceBuilder.createResource((Object)this, "/org/richfaces/ui.pack.js").encode(context, null);
                            }
                            catch (ResourceNotFoundException e) {
                                if (!log.isWarnEnabled()) break block39;
                                log.warn((Object)("No aggregated javaScript library found " + e.getMessage()));
                            }
                        }
                    }
                }
            }
            if ("NONE".equals(this.styleStrategy)) {
                this.processStyles = false;
            } else if ("ALL".equals(this.styleStrategy)) {
                this.processStyles = false;
                if (!this.ajaxRequest) {
                    try {
                        this.useSkinning = this.encodeSkinningResources(context, this.resourceBuilder);
                        this.resourceBuilder.createResource((Object)this, "/org/richfaces/skin.xcss").encode(context, null);
                    }
                    catch (ResourceNotFoundException e) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("No stylesheet found " + e.getMessage()));
                        }
                    }
                }
            } else {
                this.useSkinning = this.encodeSkinningResources(context, this.resourceBuilder);
            }
            this.traverse(context, (UIComponent)context.getViewRoot());
            context.setResponseWriter((ResponseWriter)this.componentWriter);
            if (null != skinStyleSheetUri) {
                resourceURL = context.getApplication().getViewHandler().getResourceURL(context, skinStyleSheetUri);
                resourceImpl = new URIInternetResource();
                resourceImpl.setUri(resourceURL);
                resourceImpl.setRenderer(this.resourceBuilder.getStyleRenderer());
                resourceImpl.encode(context, null);
                this.useSkinning = true;
            }
            if (null != skinExtendedStyleSheetUri && this.extendedSkinningAllowed) {
                resourceURL = context.getApplication().getViewHandler().getResourceURL(context, skinExtendedStyleSheetUri);
                resourceImpl = new URIInternetResource();
                resourceImpl.setUri(resourceURL);
                resourceImpl.setRenderer(this.resourceBuilder.getStyleRenderer());
                resourceImpl.encode(context, null, EXTENDED_SKINNING);
                this.useSkinning = true;
            }
            if (this.useSkinning && this.extendedSkinningAllowed) {
                if (!this.ajaxRequest) {
                    if (!scriptsOff) {
                        EXTENDED_SKINNING_ON_RESOURCE.encode(context, null);
                    } else {
                        Map applicationMap = context.getExternalContext().getApplicationMap();
                        if (applicationMap.get(EXTENDED_SKINNING_ON_NO_SCRIPTS_INFO_KEY) == null) {
                            ResponseWriter writer = context.getResponseWriter();
                            try {
                                StringWriter stringWriter = new StringWriter();
                                if (oldResponseWriter != null) {
                                    context.setResponseWriter(oldResponseWriter.cloneWithWriter((Writer)stringWriter));
                                } else {
                                    context.setResponseWriter(this.renderKit.createResponseWriter((Writer)stringWriter, "text/html", "US-ASCII"));
                                }
                                EXTENDED_SKINNING_ON_RESOURCE.encode(context, null);
                                stringWriter.flush();
                                log.info((Object)("Extended skinning is on and NONE scripts loading strategy was detected. Do not forget that one of /org/richfaces/renderkit/html/scripts/skinning.js or /org/ajax4jsf/framework.pack.js resources should be presented on the page together with the following code: \n" + stringWriter.getBuffer().toString() + "\nfor extended level of skinning to work."));
                            }
                            finally {
                                if (writer != null) {
                                    context.setResponseWriter(writer);
                                }
                            }
                            applicationMap.put(EXTENDED_SKINNING_ON_NO_SCRIPTS_INFO_KEY, Boolean.TRUE);
                        }
                    }
                }
                if (this.processScripts) {
                    InternetResource resource = this.resourceBuilder.createResource(null, "/org/richfaces/renderkit/html/scripts/skinning.js");
                    resource.encode(context, null);
                }
            }
            this.componentWriter.endDocument();
            this.userWriter.endDocument();
        }
        catch (IOException e) {
            throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            if (oldResponseWriter != null) {
                context.setResponseWriter(oldResponseWriter);
            }
        }
    }

    static {
        EXTENDED_SKINNING.put("media", "rich-extended-skinning");
    }

    class HeadResponseWriter
    extends SAXResponseWriter {
        public List getEventsList() {
            return ((ResponseWriterContentHandler)this.getXmlConsumer()).events;
        }

        public HeadResponseWriter(String linkClass) {
            super(new ResponseWriterContentHandler(linkClass));
        }
    }
}

