/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.io.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;
import org.ajax4jsf.context.SAXEndElementEvent;
import org.ajax4jsf.context.SAXStartElementEvent;
import org.ajax4jsf.context.SAXTextEvent;
import org.ajax4jsf.io.FastBufferReader;
import org.ajax4jsf.io.parser.ParserState;
import org.ajax4jsf.io.parser.ParsingContext;
import org.ajax4jsf.io.parser.ParsingStateManager;
import org.ajax4jsf.webapp.HtmlParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastHtmlParser
implements HtmlParser {
    private static final Log log = LogFactory.getLog(FastHtmlParser.class);
    private String encoding;
    private String doctype;
    private String viewState;
    private String mimeType;
    private Object[] headEvents;

    public void parse(Reader in, Writer out) throws IOException {
        int nextChar;
        boolean haveHtml = false;
        boolean haveHead = false;
        boolean closingElement = false;
        boolean parsed = false;
        ParsingStateManager stateManager = ParsingStateManager.getInstance();
        ParserState state = stateManager.getInitialState();
        ParsingContext context = new ParsingContext(out);
        while ((nextChar = in.read()) > 0) {
            parsed = true;
            char c = (char)nextChar;
            state = state.getNextState(c, context);
            if (log.isDebugEnabled()) {
                Class<?> stateMgrClass = stateManager.getClass();
                Field[] fields = stateMgrClass.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    try {
                        if (field.get(stateManager) != state) continue;
                        log.debug((Object)("Parser reached state is StateManager." + field.getName()));
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            state.send(c, context);
            if (state == stateManager.LT) {
                closingElement = false;
                continue;
            }
            if (state == stateManager.CLOSINGELEMENT) {
                closingElement = true;
                continue;
            }
            if (state == stateManager.ENDELEMENT) {
                if (context.getLastMatched() == stateManager.HTML) {
                    haveHtml = true;
                    if (!context.contains("xmlns=")) {
                        context.insert(" xmlns=\"http://www.w3.org/1999/xhtml\"");
                    }
                    context.send();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Found <html> element");
                    continue;
                }
                if (context.getLastMatched() == stateManager.HEAD) {
                    haveHead = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Found <head> element");
                    }
                    if (closingElement) {
                        this.writeToHead(out, haveHtml, haveHead);
                        break;
                    }
                    context.send();
                    continue;
                }
                if (context.getLastMatched() == stateManager.TITLE) {
                    context.send();
                    haveHead = true;
                    haveHtml = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Found <title> element");
                    continue;
                }
                if (context.getLastMatched() == stateManager.BASE) {
                    context.send();
                    haveHead = true;
                    haveHtml = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Found <base> element");
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"non <html> or <head><title>|<base> element");
                }
                this.writeToHead(out, haveHtml, haveHead);
                break;
            }
            if (state != stateManager.ELEMENT) continue;
            this.writeToHead(out, haveHtml, haveHead);
            break;
        }
        context.send();
        if (in instanceof FastBufferReader) {
            FastBufferReader fastIn = (FastBufferReader)in;
            fastIn.writeTo(out);
        } else {
            char[] buffer = new char[1024];
            int buffersCount = -1;
            int length = in.read(buffer);
            while (length > 0) {
                out.write(buffer, 0, length);
                ++buffersCount;
                length = in.read(buffer);
            }
        }
        if (!haveHtml && parsed) {
            out.write("</html>");
        }
    }

    private void writeToHead(Writer out, boolean haveHtml, boolean haveHead) throws IOException {
        if (!haveHead && !haveHtml) {
            out.write("<html  xmlns=\"http://www.w3.org/1999/xhtml\">");
        }
        if (!haveHead) {
            out.write("<head>");
        }
        if (this.headEvents != null && this.headEvents.length > 0) {
            LinkedList<Boolean> closedStack = new LinkedList<Boolean>();
            for (Object event : this.headEvents) {
                if (event instanceof SAXStartElementEvent) {
                    SAXStartElementEvent startElementEvent = (SAXStartElementEvent)event;
                    if (!closedStack.isEmpty() && Boolean.FALSE.equals(closedStack.peek())) {
                        out.write(62);
                        closedStack.set(0, Boolean.TRUE);
                    }
                    out.write(60);
                    out.write(startElementEvent.getName());
                    for (Map.Entry<String, String> entry : startElementEvent.getAttributes().entrySet()) {
                        String name = entry.getKey();
                        String value = entry.getValue();
                        out.write(32);
                        out.write(name);
                        out.write("='");
                        out.write(value);
                        out.write(39);
                    }
                    closedStack.addFirst(Boolean.FALSE);
                    continue;
                }
                if (event instanceof SAXTextEvent) {
                    SAXTextEvent textEvent = (SAXTextEvent)event;
                    if (!closedStack.isEmpty() && Boolean.FALSE.equals(closedStack.peek())) {
                        out.write(62);
                        closedStack.set(0, Boolean.TRUE);
                    }
                    out.write(textEvent.getText());
                    continue;
                }
                if (event instanceof SAXEndElementEvent) {
                    SAXEndElementEvent endElementEvent = (SAXEndElementEvent)event;
                    String elementName = endElementEvent.getName();
                    if (Boolean.FALSE.equals(closedStack.removeFirst())) {
                        if ("script".equals(elementName)) {
                            out.write(62);
                            out.write("</");
                            out.write(elementName);
                            out.write(62);
                            continue;
                        }
                        out.write(" />");
                        continue;
                    }
                    out.write("</");
                    out.write(elementName);
                    out.write(62);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        if (!haveHead) {
            out.write("</head>");
        }
    }

    public void parseHtml(InputStream input, Writer output) throws IOException {
        this.parse(new InputStreamReader(input, this.encoding), output);
    }

    public void parseHtml(Reader input, Writer output) throws IOException {
        this.parse(input, output);
    }

    public void setInputEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOutputEncoding(String encoding) {
    }

    public void setMoveElements(boolean move) {
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public void setViewState(String viewState) {
        this.viewState = viewState;
    }

    public boolean setMime(String mimeType) {
        this.mimeType = mimeType;
        return true;
    }

    public void setHeadEvents(Object[] events) {
        this.headEvents = events;
    }
}

