/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.component.AjaxContainer;
import org.ajax4jsf.component.AjaxLoadBundleComponent;
import org.ajax4jsf.component.AjaxSupport;
import org.ajax4jsf.component.AjaxViewRoot;
import org.ajax4jsf.component.JavaScriptParameter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AJAXDataSerializer;
import org.ajax4jsf.renderkit.RendererUtils;
import org.ajax4jsf.util.ServicesUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxRendererUtils {
    public static final String AJAX_FUNCTION_NAME = "A4J.AJAX.Submit";
    public static final String STATUS_ATTR_NAME = "status";
    public static final String ONCOMPLETE_ATTR_NAME = "oncomplete";
    public static final String ONCOMPLETE_CONTENT_ID = "org.ajax4jsf.oncomplete";
    public static final String ONBEFOREDOMUPDATE_ATTR_NAME = "onbeforedomupdate";
    public static final String LIMITTOLIST_ATTR_NAME = "limitToList";
    private static Log log = LogFactory.getLog(AjaxRendererUtils.class);
    public static final String AJAX_REGIONS_ATTRIBUTE = "reRender";
    private static final Class<?> OBJECT_ARRAY_CLASS = new Object[0].getClass();
    public static final String VALUE_ATTR = "value";
    public static final String AJAX_AREAS_RENDERED = "org.ajax4jsf.areas.rendered";
    public static final String AJAX_SINGLE_ATTR = "ajaxSingle";
    public static final String AJAX_QUEUE_ATTR = "eventsQueue";
    public static final String AJAX_DELAY_ATTR = "requestDelay";
    public static final String AJAX_ABORT_ATTR = "ignoreDupResponses";
    public static final String AJAX_PROCESS_ATTR = "process";
    public static final String AJAX_PROCESS_PARAMETER_NAME = "process";
    public static final String AJAX_SINGLE_PARAMETER_NAME = "ajaxSingle";

    private AjaxRendererUtils() {
    }

    public static StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext) {
        return AjaxRendererUtils.buildOnEvent(uiComponent, facesContext, "onclick");
    }

    public static StringBuffer buildOnEvent(UIComponent uiComponent, FacesContext facesContext, String eventName) {
        AjaxSupport support;
        String commandOnEvent;
        StringBuffer onEvent = new StringBuffer();
        if (null != eventName && (commandOnEvent = (String)uiComponent.getAttributes().get(eventName)) != null) {
            onEvent.append(commandOnEvent);
            onEvent.append(';');
        }
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(uiComponent, facesContext);
        ajaxFunction.addParameter(AjaxRendererUtils.buildEventOptions(facesContext, uiComponent));
        ajaxFunction.appendScript(onEvent);
        if (uiComponent instanceof AjaxSupport && (support = (AjaxSupport)uiComponent).isDisableDefault()) {
            onEvent.append("; return false;");
        }
        log.debug((Object)Messages.getMessage((String)"BUILD_ONCLICK_INFO", (Object)uiComponent.getId(), (Object)onEvent.toString()));
        return onEvent;
    }

    public static Map<String, Object> buildEventOptions(FacesContext facesContext, UIComponent uiComponent) {
        String encoding;
        Integer timeout;
        Boolean ignoreDupResponses;
        String status;
        String beforeupdate;
        String oncomplete;
        String clientId = uiComponent.getClientId(facesContext);
        Map componentAttributes = uiComponent.getAttributes();
        HashMap<String, Object> options = new HashMap<String, Object>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        UIComponent targetComponent = uiComponent instanceof AjaxSupport ? uiComponent.getParent() : uiComponent;
        boolean input = targetComponent instanceof EditableValueHolder;
        boolean ajaxSingle = Boolean.TRUE.equals(componentAttributes.get("ajaxSingle"));
        if (ajaxSingle) {
            parameters.put("ajaxSingle", targetComponent.getClientId(facesContext));
            if (componentAttributes.get("process") != null) {
                parameters.put("process", true);
            }
            if (input) {
                options.put("control", JSReference.THIS);
            }
        }
        String controlName = clientId;
        String controlValue = clientId;
        parameters.put(controlName, controlValue);
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
        options.put("actionUrl", ajaxContext.getAjaxActionURL(facesContext));
        parameters.putAll(ajaxContext.getCommonAjaxParameters());
        for (UIComponent child : uiComponent.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            Object value = ((UIParameter)child).getValue();
            if (null == name) {
                throw new IllegalArgumentException(Messages.getMessage((String)"UNNAMED_PARAMETER_ERROR", (Object)uiComponent.getClientId(facesContext)));
            }
            boolean escape = true;
            if (child instanceof JavaScriptParameter) {
                JavaScriptParameter actionParam = (JavaScriptParameter)child;
                boolean bl = escape = !actionParam.isNoEscape();
            }
            if (escape) {
                parameters.put(name, value);
                continue;
            }
            parameters.put(name, new JSReference(value.toString()));
        }
        if (!parameters.isEmpty()) {
            options.put("parameters", parameters);
        }
        if (AjaxRendererUtils.isAjaxLimitToList(uiComponent)) {
            Set<String> ajaxAreas = AjaxRendererUtils.getAjaxAreas(uiComponent);
            HashSet<String> areasIds = new HashSet<String>();
            if (null != ajaxAreas) {
                for (String id : ajaxAreas) {
                    UIComponent comp = RendererUtils.getInstance().findComponentFor(uiComponent, id);
                    if (null != comp) {
                        areasIds.add(comp.getClientId(facesContext));
                        continue;
                    }
                    areasIds.add(id);
                }
            }
            options.put("affected", areasIds);
        }
        if (null != (oncomplete = AjaxRendererUtils.getAjaxOncomplete(uiComponent))) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"request", "event", "data"});
            function.addToBody((Object)oncomplete);
            options.put(ONCOMPLETE_ATTR_NAME, function);
        }
        if (null != (beforeupdate = AjaxRendererUtils.getAjaxOnBeforeDomUpdate(uiComponent))) {
            JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"request", "event", "data"});
            function.addToBody((Object)beforeupdate);
            options.put(ONBEFOREDOMUPDATE_ATTR_NAME, function);
        }
        if (null != (status = AjaxRendererUtils.getAjaxStatus(uiComponent))) {
            options.put(STATUS_ATTR_NAME, status);
        }
        String queue = (String)componentAttributes.get(AJAX_QUEUE_ATTR);
        Integer requestDelay = (Integer)componentAttributes.get(AJAX_DELAY_ATTR);
        if (null != requestDelay && requestDelay > 0) {
            options.put(AJAX_DELAY_ATTR, requestDelay);
            if (null == queue) {
                queue = clientId;
            }
        }
        if (null != (ignoreDupResponses = (Boolean)componentAttributes.get(AJAX_ABORT_ATTR)) && ignoreDupResponses.booleanValue()) {
            options.put(AJAX_ABORT_ATTR, JSReference.TRUE);
            if (null == queue) {
                queue = clientId;
            }
        }
        if (null != queue) {
            options.put(AJAX_QUEUE_ATTR, queue);
        }
        if (null != (timeout = (Integer)componentAttributes.get("timeout")) && timeout > 0) {
            options.put("timeout", timeout);
        }
        if (null != (encoding = (String)componentAttributes.get("encoding"))) {
            options.put("encoding", encoding);
        }
        return options;
    }

    public static JSFunction buildAjaxFunction(UIComponent uiComponent, FacesContext facesContext) {
        JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(uiComponent, facesContext, AJAX_FUNCTION_NAME);
        ajaxFunction.addParameter((Object)new JSReference("event"));
        return ajaxFunction;
    }

    public static JSFunction buildAjaxFunction(UIComponent uiComponent, FacesContext facesContext, String functionName) {
        JSFunction ajaxFunction = new JSFunction(functionName, new Object[0]);
        UIComponent nestingContainer = (UIComponent)AjaxRendererUtils.findAjaxContainer(facesContext, uiComponent);
        String clientId = nestingContainer.getClientId(facesContext);
        if (clientId != null) {
            ajaxFunction.addParameter((Object)clientId);
        } else {
            ajaxFunction.addParameter((Object)JSReference.NULL);
        }
        UIComponent nestingForm = AjaxRendererUtils.getNestingForm(uiComponent);
        if (null == nestingForm) {
            ajaxFunction.addParameter((Object)JSReference.NULL);
        } else {
            ajaxFunction.addParameter((Object)nestingForm.getClientId(facesContext));
        }
        return ajaxFunction;
    }

    public static Set<String> getAjaxAreas(UIComponent uiComponent) {
        Object areas = uiComponent instanceof AjaxComponent ? ((AjaxComponent)uiComponent).getReRender() : uiComponent.getAttributes().get(AJAX_REGIONS_ATTRIBUTE);
        return AjaxRendererUtils.asSet(areas);
    }

    public static Set<String> asSet(Object valueToSet) {
        if (null != valueToSet) {
            if (valueToSet instanceof Set) {
                return (Set)valueToSet;
            }
            if (valueToSet instanceof Collection) {
                return new HashSet<String>((Collection)valueToSet);
            }
            if (OBJECT_ARRAY_CLASS.isAssignableFrom(valueToSet.getClass())) {
                return new HashSet<String>(Arrays.asList((String[])valueToSet));
            }
            if (valueToSet instanceof String) {
                String areasString = (String)valueToSet;
                if (areasString.indexOf(",") > 0) {
                    return new HashSet<String>(Arrays.asList(areasString.trim().split("(\\s)*,(\\s)*")));
                }
                HashSet<String> areasSet = new HashSet<String>(5);
                areasSet.add(areasString.trim());
                return areasSet;
            }
        }
        return null;
    }

    public static String getAjaxStatus(UIComponent component) {
        String statusId = component instanceof AjaxComponent ? ((AjaxComponent)component).getStatus() : (String)component.getAttributes().get(STATUS_ATTR_NAME);
        if (null != statusId) {
            UIComponent status = RendererUtils.getInstance().findComponentFor(component, statusId);
            if (null != status) {
                statusId = status.getClientId(FacesContext.getCurrentInstance());
            } else {
                log.warn((Object)Messages.getMessage((String)"AJAX_STATUS_COMPONENT_NOT_FOWND_WARNING", (Object)component.getId()));
            }
        }
        return statusId;
    }

    public static String getAjaxOncomplete(UIComponent component) {
        if (component instanceof AjaxComponent) {
            return ((AjaxComponent)component).getOncomplete();
        }
        return (String)component.getAttributes().get(ONCOMPLETE_ATTR_NAME);
    }

    public static String getAjaxOnBeforeDomUpdate(UIComponent component) {
        if (component instanceof AjaxComponent) {
            return ((AjaxComponent)component).getOnbeforedomupdate();
        }
        return (String)component.getAttributes().get(ONBEFOREDOMUPDATE_ATTR_NAME);
    }

    public static boolean isAjaxLimitToList(UIComponent component) {
        boolean result = false;
        if (component instanceof AjaxComponent) {
            result = ((AjaxComponent)component).isLimitToList();
        } else {
            try {
                result = (Boolean)component.getAttributes().get(LIMITTOLIST_ATTR_NAME);
            }
            catch (NullPointerException e) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getAbsoluteId(UIComponent component) {
        if (component == null) {
            throw new NullPointerException(Messages.getMessage((String)"COMPONENT_NULL_ERROR_2"));
        }
        StringBuffer idBuf = new StringBuffer();
        idBuf.append(component.getId());
        UIComponent parent = component;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof NamingContainer)) continue;
            idBuf.insert(0, ':');
            idBuf.insert(0, parent.getId());
        }
        idBuf.insert(0, ':');
        log.debug((Object)Messages.getMessage((String)"CALCULATE_COMPONENT_ID_INFO", (Object)component.getId(), (Object)idBuf.toString()));
        return idBuf.toString();
    }

    public static UIComponent getNestingForm(UIComponent component) {
        UIComponent parent;
        for (parent = component; !(parent == null || parent instanceof UIForm || "org.apache.myfaces.trinidad.Form".equals(parent.getFamily()) || "oracle.adf.Form".equals(parent.getFamily())); parent = parent.getParent()) {
        }
        return parent;
    }

    protected static String getAjaxActionUrl(FacesContext facesContext) {
        return AjaxContext.getCurrentInstance((FacesContext)facesContext).getAjaxActionURL(facesContext);
    }

    public static AjaxContainer findAjaxContainer(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); parent != null && !(parent instanceof AjaxContainer); parent = parent.getParent()) {
        }
        AjaxContainer nestingContainer = null;
        if (parent != null) {
            nestingContainer = (AjaxContainer)parent;
        } else if (facesContext.getViewRoot() instanceof AjaxViewRoot) {
            nestingContainer = (AjaxContainer)facesContext.getViewRoot();
        }
        return nestingContainer;
    }

    public static void encodeAreas(FacesContext context, UIComponent component) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Set rendered = ajaxContext.getAjaxRenderedAreas();
        StringBuffer senderString = new StringBuffer();
        ResponseWriter out = context.getResponseWriter();
        out.startElement("meta", component);
        out.writeAttribute("name", (Object)"Ajax-Update-Ids", null);
        Iterator it = rendered.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            senderString.append(id);
            if (!it.hasNext()) continue;
            senderString.append(',');
        }
        out.writeAttribute("content", (Object)senderString, null);
        out.endElement("meta");
        out.startElement("span", component);
        out.writeAttribute("id", (Object)"ajax-view-state", null);
        AjaxRendererUtils.writeState(context);
        out.endElement("span");
        out.startElement("meta", component);
        out.writeAttribute("id", (Object)"Ajax-Response", null);
        out.writeAttribute("name", (Object)"Ajax-Response", null);
        out.writeAttribute("content", (Object)"true", null);
        out.endElement("meta");
        Object response = externalContext.getResponse();
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader("Ajax-Response", "true");
        } else {
            try {
                Method setHeadergMethod = response.getClass().getMethod("setHeader", String.class, String.class);
                setHeadergMethod.invoke(response, "Ajax-Response", "true");
            }
            catch (Exception e) {
                log.error((Object)Messages.getMessage((String)"DETECTING_ENCODING_DISABLED_ERROR"));
                log.error((Object)Messages.getMessage((String)"OBTAIN_RESPONSE_SET_HEADER_ERROR", (Object)e));
            }
        }
        Map responseDataMap = ajaxContext.getResponseDataMap();
        AJAXDataSerializer serializer = (AJAXDataSerializer)ServicesUtils.getServiceInstance(AJAXDataSerializer.SERVICE);
        for (Object dataKey : responseDataMap.keySet()) {
            out.startElement("span", component);
            out.writeAttribute("id", dataKey, null);
            String dataString = serializer.asString(responseDataMap.get(dataKey));
            out.write(dataString);
            out.endElement("span");
        }
        Object oncomplete = ajaxContext.getOncomplete();
        if (null != oncomplete) {
            out.startElement("span", component);
            out.writeAttribute("id", (Object)ONCOMPLETE_CONTENT_ID, null);
            out.writeText(oncomplete, null);
            out.endElement("span");
        }
        requestMap.put(AJAX_AREAS_RENDERED, "true");
    }

    public static void writeState(FacesContext context) throws IOException {
        context.getApplication().getViewHandler().writeState(context);
    }

    public static void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("html", component);
        Locale locale = context.getViewRoot().getLocale();
        out.writeAttribute("lang", (Object)locale.toString(), "lang");
        out.startElement("body", component);
    }

    public static void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        AjaxRendererUtils.encodeAreas(context, component);
        out.endElement("body");
        out.endElement("html");
    }

    public static void loadBundles(FacesContext context) {
        AjaxRendererUtils.loadBundles(context, (UIComponent)context.getViewRoot());
    }

    private static void loadBundles(FacesContext context, UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            AjaxRendererUtils.loadCildBundles(context, child);
        }
        for (UIComponent child : component.getFacets().values()) {
            AjaxRendererUtils.loadCildBundles(context, child);
        }
    }

    private static void loadCildBundles(FacesContext context, UIComponent child) {
        if (child instanceof AjaxLoadBundleComponent) {
            try {
                child.encodeBegin(context);
            }
            catch (IOException iOException) {}
        } else {
            AjaxRendererUtils.loadBundles(context, child);
        }
    }

    public static boolean isAjaxRequest(FacesContext facesContext) {
        return AjaxContext.getCurrentInstance((FacesContext)facesContext).isAjaxRequest();
    }

    public static void addRegionByName(FacesContext facesContext, UIComponent component, String id) {
        AjaxContext.getCurrentInstance((FacesContext)facesContext).addComponentToAjaxRender(component, id);
    }

    public static void addRegionsFromComponent(UIComponent component, FacesContext facesContext) {
        AjaxContext.getCurrentInstance((FacesContext)facesContext).addRegionsFromComponent(component);
    }
}

