/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.ajax4jsf.context;

import java.util.HashMap;
import java.util.Map;

/**
 * Created 19.07.2008
 * @author Nick Belaevski
 * @since 3.2.2
 */

public class SAXStartElementEvent {

	private String name;
	
	private Map<String, String> attributes;
	
	/**
	 * Constructor that parses string into map for usage in unit tests
	 * @param name
	 * @param attributesString
	 */
	public SAXStartElementEvent(String name, String attributesString) {
		super();
		this.name = name;
		
		Map<String, String> attributes = null;
		if (attributesString != null) {
			attributes = new HashMap<String, String>();
			String[] split = attributesString.split(",");
			for (String s : split) {
				String[] split2 = s.split("=");
			
				attributes.put(split2[0], split2[1]);
			}
		}

		this.attributes = attributes;
	}

	public SAXStartElementEvent(String name, Map<String, String> attributes) {
		super();
		this.name = name;
		this.attributes = attributes;
	}
	
	public String getName() {
		return name;
	}
	
	public Map<String, String> getAttributes() {
		return attributes;
	}
	
	@Override
	public String toString() {
		return "<" + name + " " + attributes + " >";
	}
}
