/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.compiler;

import java.io.IOException;
import javax.faces.FacesException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.compiler.ClassElement;
import org.ajax4jsf.renderkit.compiler.ElementBase;
import org.ajax4jsf.renderkit.compiler.MethodCallElement;
import org.ajax4jsf.renderkit.compiler.PreparedTemplate;
import org.ajax4jsf.renderkit.compiler.ResourceElement;
import org.ajax4jsf.renderkit.compiler.TemplateContext;
import org.ajax4jsf.renderkit.compiler.TextElement;
import org.xml.sax.SAXException;

public class AttributeElement
extends ElementBase {
    private String name;
    private boolean mandatory = true;

    public void encode(TemplateContext context) throws IOException {
        String attributeValue = this.getString(context);
        if (attributeValue.length() > 0 || this.isMandatory()) {
            context.getWriter().writeAttribute(this.getName(), (Object)attributeValue, null);
        }
    }

    public void encode(TemplateContext context, String breakPoint) throws IOException {
        throw new FacesException(Messages.getMessage((String)"BREAKPOINTS_UNSUPPORTED_INSIDE_ATTRIBUTE_ERROR", (Object)this.getName(), (Object)context.getComponent().getId()));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMantadory(boolean notNull) {
        this.mandatory = notNull;
    }

    public void setMandatory(boolean notNull) {
        this.mandatory = notNull;
    }

    public String getTag() {
        return "f:attribute";
    }

    public void setParent(PreparedTemplate parent) throws SAXException {
        super.setParent(parent);
        if (this.getName() == null) {
            throw new SAXException(Messages.getMessage((String)"NO_NAME_ATTRIBUTE_ERROR", (Object)this.getTag()));
        }
    }

    protected Class[] getAllowedClasses() {
        return new Class[]{MethodCallElement.class, TextElement.class, ResourceElement.class, ClassElement.class};
    }
}

