/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.tests;

import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.http.HttpSession;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.tests.AbstractAjax4JsfTestCase;
import org.apache.shale.test.mock.MockFacesContext;
import org.apache.shale.test.mock.MockHttpServletRequest;
import org.apache.shale.test.mock.MockHttpServletResponse;
import org.apache.shale.test.mock.MockHttpSession;

public class AbstractThreadedAjax4JsfTestCase
extends AbstractAjax4JsfTestCase {
    private Thread[] threads = null;
    private TestResult testResult = null;

    public AbstractThreadedAjax4JsfTestCase(String s) {
        super(s);
    }

    public void interruptThreads() {
        if (this.threads != null) {
            for (int i = 0; i < this.threads.length; ++i) {
                this.threads[i].interrupt();
            }
        }
    }

    public void run(TestResult result) {
        this.testResult = result;
        super.run(result);
        this.testResult = null;
    }

    protected void runTestCaseThreads(Class clazz, int numThreads) {
        TestCaseRunnable[] runnables = new TestCaseRunnable[numThreads];
        for (int i = 0; i < runnables.length; ++i) {
            try {
                runnables[i] = (TestCaseRunnable)clazz.newInstance();
                continue;
            }
            catch (Exception e) {
                this.testResult.addError((Test)this, (Throwable)e);
                return;
            }
        }
        this.runTestCaseRunnables(runnables);
    }

    protected void runTestCaseRunnables(TestCaseRunnable[] runnables) {
        int i;
        if (runnables == null) {
            throw new IllegalArgumentException("runnables is null");
        }
        this.threads = new Thread[runnables.length];
        for (i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new Thread(runnables[i]);
        }
        for (i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
        }
        try {
            for (i = 0; i < this.threads.length; ++i) {
                this.threads[i].join();
            }
        }
        catch (InterruptedException ignore) {
            System.out.println("Thread join interrupted.");
        }
        this.threads = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Throwable t) {
        TestResult testResult = this.testResult;
        synchronized (testResult) {
            if (t instanceof AssertionFailedError) {
                this.testResult.addFailure((Test)this, (AssertionFailedError)t);
            } else {
                this.testResult.addError((Test)this, t);
            }
        }
    }

    protected FacesContext createFacesContext() {
        MockHttpSession tsession = new MockHttpSession();
        MockHttpServletRequest trequest = new MockHttpServletRequest((HttpSession)tsession);
        trequest.setAttribute("ajaxContext", (Object)new AjaxContextImpl());
        MockHttpServletResponse tresponse = new MockHttpServletResponse();
        MockFacesContext tfacesContext = (MockFacesContext)this.facesContextFactory.getFacesContext((Object)this.servletContext, (Object)trequest, (Object)tresponse, (Lifecycle)this.lifecycle);
        tfacesContext.setApplication((Application)this.application);
        tfacesContext.setViewRoot(this.application.getViewHandler().createView((FacesContext)this.facesContext, this.facesContext.getViewRoot().getViewId()));
        return tfacesContext;
    }

    public abstract class TestCaseRunnable
    implements Runnable {
        public abstract void runTestCase(FacesContext var1) throws Throwable;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            FacesContext context = null;
            try {
                context = AbstractThreadedAjax4JsfTestCase.this.createFacesContext();
                this.runTestCase(context);
            }
            catch (Throwable t) {
                AbstractThreadedAjax4JsfTestCase.this.handleException(t);
                AbstractThreadedAjax4JsfTestCase.this.interruptThreads();
            }
            finally {
                if (null != context) {
                    context.release();
                }
            }
        }
    }
}

