/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.tests;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.ajax4jsf.tests.MockRange;

public class MockDataModel
extends ExtendedDataModel {
    public static final int ROWS = 10;
    private int rowIndex = 0;
    private int minRow = 0;
    private int maxRow = 10;
    private Object wrappedData;

    public int getMaxRow() {
        return this.maxRow;
    }

    public void setMaxRow(int maxRow) {
        this.maxRow = maxRow;
    }

    public int getMinRow() {
        return this.minRow;
    }

    public void setMinRow(int minRow) {
        this.minRow = minRow;
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        int first = 0;
        int count = 10;
        if (range instanceof MockRange) {
            MockRange mockRange = (MockRange)range;
            count = mockRange.getCount();
        } else if (range instanceof SequenceRange) {
            SequenceRange seqRange = (SequenceRange)range;
            first = seqRange.getFirstRow();
            int rows = seqRange.getRows();
            if (rows > 0) {
                count = rows + first;
            }
        }
        for (int row = first; row < count && row < 10; ++row) {
            visitor.process(context, (Object)new Integer(row), argument);
        }
    }

    public Object getRowKey() {
        return this.rowIndex < 0 ? null : new Integer(this.rowIndex);
    }

    public void setRowKey(Object key) {
        this.rowIndex = null == key ? -1 : (Integer)key;
    }

    public int getRowCount() {
        return this.getMaxRow();
    }

    public Object getRowData() {
        return this.isRowAvailable() ? String.valueOf(this.rowIndex) : null;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object getWrappedData() {
        return this.wrappedData;
    }

    public boolean isRowAvailable() {
        return this.rowIndex >= this.getMinRow() && this.rowIndex < this.getMaxRow();
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public void setWrappedData(Object data) {
        this.wrappedData = data;
    }
}

