/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockMethodExpression
extends MethodExpression {
    private MethodExpressionInvocationResult result;
    private String expressionString;
    private List<Object[]> invocationArgs = new ArrayList<Object[]>();

    public MockMethodExpression(String expressionString, Class<?> returnType, MethodExpressionInvocationResult result) {
        this.expressionString = expressionString;
        this.result = result;
    }

    public MethodInfo getMethodInfo(ELContext context) {
        return null;
    }

    public Object invoke(ELContext context, Object[] params) {
        this.invocationArgs.add(params);
        Object returnValue = null;
        if (this.result != null) {
            returnValue = this.result.invoke(context, params);
        }
        return returnValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodExpression) {
            MethodExpression expression = (MethodExpression)obj;
            return this.expressionString != null && expression.getExpressionString() != null && this.expressionString.equals(expression.getExpressionString());
        }
        return false;
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    public int hashCode() {
        return this.expressionString == null ? 0 : this.expressionString.hashCode();
    }

    public boolean isLiteralText() {
        return this.expressionString != null && !this.expressionString.contains("${") && !this.expressionString.contains("#{");
    }

    public List<Object[]> getInvocationArgs() {
        return this.invocationArgs;
    }

    public void reset() {
        this.invocationArgs.clear();
    }

    public boolean lastInvocationMatched(Object ... objects) {
        if (!this.invocationArgs.isEmpty()) {
            Object[] argz = this.invocationArgs.get(this.invocationArgs.size() - 1);
            return Arrays.equals(objects, argz);
        }
        return false;
    }

    public static interface MethodExpressionInvocationResult {
        public Object invoke(ELContext var1, Object ... var2);
    }
}

