/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.tests;

import com.gargoylesoftware.htmlunit.MockWebConnection;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.renderkit.AjaxViewRootRenderer;
import org.ajax4jsf.renderkit.ChameleonRenderKitImpl;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.tests.Condition;
import org.ajax4jsf.tests.DummyScriptEngine;
import org.ajax4jsf.tests.EnumSupportExpressionFactoryWrapper;
import org.ajax4jsf.tests.MockExternalContext;
import org.ajax4jsf.tests.MockFacesResourceContext;
import org.ajax4jsf.tests.MockViewHandler;
import org.ajax4jsf.tests.MockViewRoot;
import org.ajax4jsf.tests.org.apache.shale.test.config.ConfigParser;
import org.ajax4jsf.webapp.WebXml;
import org.apache.shale.test.base.AbstractJsfTestCase;
import org.apache.shale.test.mock.MockPrintWriter;
import org.apache.shale.test.mock.MockResponseWriter;
import org.apache.shale.test.mock.MockServletOutputStream;
import org.richfaces.VersionBean;
import org.richfaces.skin.SkinBean;
import org.richfaces.skin.SkinFactory;

public class AbstractAjax4JsfTestCase
extends AbstractJsfTestCase {
    protected static final String SLASHED_RESOURCE_URI_PREFIX = "/a4j_3_2_1-SNAPSHOT";
    private File tmpRoot = null;
    protected ELContext elContext;
    protected ExpressionFactory expressionFactory;
    protected AjaxContext ajaxContext = null;
    protected ChameleonRenderKitImpl vcpRenderKit = null;
    protected MockResponseWriter writer;
    protected WebClient webClient = null;
    protected MockWebConnection webConnection = null;
    private ClassLoader threadContextClassLoader = null;
    protected WebXml webXml;

    public static final void evaluate(Condition condition) {
        String message = condition.getMessage();
        AbstractAjax4JsfTestCase.assertTrue((String)message, (boolean)condition.isConditionTrue());
    }

    public AbstractAjax4JsfTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        super.setUp();
        try {
            EnumSupportExpressionFactoryWrapper exprFact = new EnumSupportExpressionFactoryWrapper(this.application.getExpressionFactory());
            Class<?> applicationClass = this.application.getClass();
            Field field = applicationClass.getDeclaredField("expressionFactory");
            field.setAccessible(true);
            field.set(this.application, (Object)exprFact);
            this.expressionFactory = this.application.getExpressionFactory();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.servletContext.addInitParameter("org.richfaces.SKIN", this.getSkinName());
        this.servletContext.addInitParameter("com.sun.faces.externalizeJavaScript", "true");
        RenderKitFactory vcpRenderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.vcpRenderKit = new ChameleonRenderKitImpl();
        vcpRenderKitFactory.addRenderKit("HTML_CHAMELEON", (RenderKit)this.vcpRenderKit);
        this.renderKit.addRenderer("javax.faces.ViewRoot", "javax.faces.ViewRoot", (Renderer)new AjaxViewRootRenderer());
        this.application.addComponent("javax.faces.ViewRoot", MockViewRoot.class.getName());
        this.ajaxContext = new AjaxContextImpl();
        this.request.setAttribute("ajaxContext", (Object)this.ajaxContext);
        this.application.setViewHandler((ViewHandler)new MockViewHandler(this.application.getViewHandler()));
        MockViewRoot root = new MockViewRoot();
        root.setViewId("/viewId");
        root.setRenderKitId("HTML_BASIC");
        this.facesContext.setViewRoot((UIViewRoot)root);
        this.servletContext.setAttribute("a4j", (Object)new VersionBean());
        this.servletContext.setAttribute("a4jSkin", (Object)new SkinBean());
        this.request.setPathElements("/testContext", "/faces", "/vievId.jsf", "");
        File webRoot = new File(((Object)((Object)this)).getClass().getResource("/WEB-INF/web.xml").getFile()).getParentFile().getParentFile();
        if (webRoot.exists()) {
            this.servletContext.setDocumentRoot(webRoot);
        } else {
            this.tmpRoot = File.createTempFile("TmpTestRoot" + new Random().nextInt(), null);
            this.tmpRoot.delete();
            this.tmpRoot.mkdir();
            this.servletContext.setDocumentRoot(this.tmpRoot);
            URL jarUrl = AbstractAjax4JsfTestCase.class.getProtectionDomain().getCodeSource().getLocation();
            ZipInputStream zis = new ZipInputStream(jarUrl.openStream());
            try {
                ZipEntry entry;
                byte[] buffer = new byte[8192];
                while ((entry = zis.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (!name.startsWith("WEB-INF/")) continue;
                    File out = new File(this.tmpRoot, name);
                    if (entry.isDirectory()) {
                        out.mkdirs();
                        continue;
                    }
                    out.getParentFile().mkdirs();
                    FileOutputStream os = new FileOutputStream(out);
                    try {
                        int count;
                        while ((count = zis.read(buffer)) > 0) {
                            ((OutputStream)os).write(buffer, 0, count);
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                    zis.closeEntry();
                }
            }
            catch (IOException e) {
                this.deleteRecursively(this.tmpRoot);
                throw e;
            }
            this.servletContext.setDocumentRoot(this.tmpRoot);
        }
        try {
            InternetResourceBuilder.getInstance().init();
        }
        catch (FacesException e) {
            InternetResourceBuilder.setInstance(null);
        }
        this.webXml = new WebXml();
        this.webXml.init((ServletContext)this.servletContext, "A4J");
        ConfigParser parser = new ConfigParser();
        parser.parse(parser.getPlatformURLs());
        Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources("META-INF/faces-config.xml");
        while (resources.hasMoreElements()) {
            parser.parse(resources.nextElement());
        }
        this.externalContext = new MockExternalContext(this.externalContext);
        this.facesContext.setExternalContext((ExternalContext)this.externalContext);
        this.elContext = this.facesContext.getELContext();
        this.expressionFactory = this.application.getExpressionFactory();
    }

    protected WebClient createWebClient() {
        WebClient client = new WebClient();
        client.setJavaScriptEnabled(true);
        client.setJavaScriptEngine((JavaScriptEngine)new DummyScriptEngine(client));
        return client;
    }

    protected void setupWebClient() {
        this.ajaxContext = null;
        this.webClient = this.createWebClient();
        this.webConnection = new MockWebConnection(this.webClient){

            public WebResponse getResponse(WebRequestSettings settings) throws IOException {
                String testResourceContextPath = AbstractAjax4JsfTestCase.this.facesContext.getExternalContext().getRequestContextPath() + AbstractAjax4JsfTestCase.SLASHED_RESOURCE_URI_PREFIX;
                if (settings.getURL().getFile().startsWith(testResourceContextPath)) {
                    String uri = settings.getURL().getFile().substring(testResourceContextPath.length());
                    InternetResourceBuilder resourceBuilder = InternetResourceBuilder.getInstance();
                    InternetResource resource = resourceBuilder.getResourceForKey(uri);
                    Object resourceData = resourceBuilder.getResourceDataForKey(uri);
                    final MockFacesResourceContext resourceContext = new MockFacesResourceContext((FacesContext)AbstractAjax4JsfTestCase.this.facesContext);
                    resourceContext.setResourceData(resourceData);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    AbstractAjax4JsfTestCase.this.response.setOutputStream((ServletOutputStream)new MockServletOutputStream(baos));
                    resource.sendHeaders((ResourceContext)resourceContext);
                    resource.send((ResourceContext)resourceContext);
                    return new WebResponseImpl(new WebResponseData((InputStream)new ByteArrayInputStream(baos.toByteArray()), 200, "OK", resourceContext.getHeaders()), settings.getURL(), settings.getSubmitMethod(), 0L){

                        public String getContentType() {
                            return resourceContext.getContentType();
                        }
                    };
                }
                return super.getResponse(settings);
            }
        };
        this.webClient.setWebConnection((WebConnection)this.webConnection);
        this.webConnection.setDefaultResponse("<html><body>not found</body></html>", 404, "NOT FOUND", "text/html");
        this.webClient.setThrowExceptionOnFailingStatusCode(false);
        this.webClient.setThrowExceptionOnScriptError(false);
    }

    private void deleteRecursively(File file) {
        if (file != null) {
            String[] list = file.list();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    String name = list[i];
                    File f = new File(file, name);
                    if (f.isDirectory()) {
                        this.deleteRecursively(f);
                        continue;
                    }
                    f.delete();
                }
            }
            file.delete();
        }
    }

    public void tearDown() throws Exception {
        this.expressionFactory = null;
        this.elContext = null;
        super.tearDown();
        this.vcpRenderKit = null;
        this.webClient = null;
        this.webConnection = null;
        this.writer = null;
        SkinFactory.reset();
        InternetResourceBuilder.setInstance(null);
        this.deleteRecursively(this.tmpRoot);
    }

    protected String getSkinName() {
        return "DEFAULT";
    }

    protected URL[] getImplementationUrls() {
        return new URL[0];
    }

    protected UIComponent createComponent(String type, String className, String rendererType, Class rendererClazz, Class skinRendererClazz) {
        Renderer renderer;
        UIComponent comp;
        try {
            comp = this.application.createComponent(type);
        }
        catch (FacesException e) {
            this.application.addComponent(type, className);
            comp = this.application.createComponent(type);
        }
        comp.setRendererType(rendererType);
        String family = comp.getFamily();
        if (null != rendererClazz && null == (renderer = this.renderKit.getRenderer(family, rendererType))) {
            try {
                renderer = (Renderer)rendererClazz.newInstance();
            }
            catch (InstantiationException e) {
                AbstractAjax4JsfTestCase.assertTrue((String)("Instantiation exception for create renderer " + rendererClazz.getName()), (boolean)false);
            }
            catch (IllegalAccessException e) {
                AbstractAjax4JsfTestCase.assertTrue((String)("ILEGAL access exception for create renderer " + rendererClazz.getName()), (boolean)false);
            }
            this.renderKit.addRenderer(family, rendererType, renderer);
        }
        if (null != skinRendererClazz && null == (renderer = this.renderKit.getRenderer(family, rendererType))) {
            try {
                renderer = (Renderer)skinRendererClazz.newInstance();
            }
            catch (InstantiationException e) {
                AbstractAjax4JsfTestCase.assertTrue((String)("Instantiation exception for create renderer " + skinRendererClazz.getName()), (boolean)false);
            }
            catch (IllegalAccessException e) {
                AbstractAjax4JsfTestCase.assertTrue((String)("ILEGAL access exception for create renderer " + skinRendererClazz.getName()), (boolean)false);
            }
            this.vcpRenderKit.addRenderer(family, rendererType, renderer);
        }
        comp.setId(this.facesContext.getViewRoot().createUniqueId());
        return comp;
    }

    protected void renderChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this.renderChild(context, child);
            }
        }
    }

    protected void renderChild(FacesContext context, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(context);
        if (child.getRendersChildren()) {
            child.encodeChildren(context);
        } else {
            this.renderChildren(context, child);
        }
        child.encodeEnd(context);
    }

    protected HtmlPage renderView() throws Exception {
        this.setupResponseWriter();
        this.renderChild((FacesContext)this.facesContext, (UIComponent)this.facesContext.getViewRoot());
        return this.processResponseWriter();
    }

    protected HtmlPage processResponseWriter() throws IOException, Exception {
        this.writer.endDocument();
        return (HtmlPage)this.processResponse();
    }

    protected void setupResponseWriter() throws IOException {
        this.writer = (MockResponseWriter)this.renderKit.createResponseWriter((Writer)this.response.getWriter(), "text/html", null);
        this.facesContext.setResponseWriter((ResponseWriter)this.writer);
        this.writer.startDocument();
    }

    protected Page processResponse() throws Exception {
        this.setupWebClient();
        URL page = new URL("http:" + this.facesContext.getExternalContext().getRequestContextPath() + this.facesContext.getViewRoot().getViewId());
        try {
            char[] content = ((MockPrintWriter)this.response.getWriter()).content();
            this.webConnection.setResponse(page, String.valueOf(content), this.response.getStatus(), "OK", this.response.getContentType(), Collections.EMPTY_LIST);
        }
        catch (IllegalStateException e) {
            byte[] content = ((MockServletOutputStream)this.response.getOutputStream()).content();
            this.webConnection.setResponse(page, content, this.response.getStatus(), "OK", this.response.getContentType(), Collections.EMPTY_LIST);
        }
        return this.webClient.getPage(page);
    }
}

