/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.tests;

import com.gargoylesoftware.htmlunit.MockWebConnection;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.WebResponseImpl;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.AjaxContextImpl;
import org.ajax4jsf.context.ViewResources;
import org.ajax4jsf.io.parser.FastHtmlParser;
import org.ajax4jsf.renderkit.AjaxViewRootRenderer;
import org.ajax4jsf.renderkit.ChameleonRenderKitImpl;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceBuilderImpl;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.image.ImageInfo;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.tests.Condition;
import org.ajax4jsf.tests.DummyScriptEngine;
import org.ajax4jsf.tests.EnumSupportExpressionFactoryWrapper;
import org.ajax4jsf.tests.HtmlTestUtils;
import org.ajax4jsf.tests.MockExternalContext;
import org.ajax4jsf.tests.MockFacesResourceContext;
import org.ajax4jsf.tests.MockViewHandler;
import org.ajax4jsf.tests.MockViewRoot;
import org.ajax4jsf.tests.TestFileUtils;
import org.ajax4jsf.tests.org.apache.shale.test.config.ConfigParser;
import org.ajax4jsf.webapp.BaseXMLFilter;
import org.ajax4jsf.webapp.HtmlParser;
import org.ajax4jsf.webapp.WebXml;
import org.apache.shale.test.base.AbstractJsfTestCase;
import org.apache.shale.test.mock.MockPrintWriter;
import org.apache.shale.test.mock.MockResponseWriter;
import org.apache.shale.test.mock.MockServletOutputStream;
import org.richfaces.VersionBean;
import org.richfaces.skin.SkinBean;
import org.richfaces.skin.SkinFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAjax4JsfTestCase
extends AbstractJsfTestCase {
    private static final String IMAGE_NOT_FOUND_OR_UNAVAILABLE_MESSAGE = "Image not found or unavailable";
    private static final String RESOURCE_NOT_FOUND_MESSAGE = "Resource not found";
    private static final String HTTP_PREFIX = "http:";
    @Deprecated
    protected static final String SLASHED_RESOURCE_URI_PREFIX = "/a4j";
    private File tmpRoot = null;
    protected ELContext elContext;
    protected ExpressionFactory expressionFactory;
    protected AjaxContext ajaxContext = null;
    protected ChameleonRenderKitImpl vcpRenderKit = null;
    protected MockResponseWriter writer;
    protected WebClient webClient = null;
    protected MockWebConnection webConnection = null;
    private ClassLoader threadContextClassLoader = null;
    protected WebXml webXml;

    public static final void evaluate(Condition condition) {
        String message = condition.getMessage();
        AbstractAjax4JsfTestCase.assertTrue((String)message, (boolean)condition.isConditionTrue());
    }

    public AbstractAjax4JsfTestCase(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() throws Exception {
        super.setUp();
        try {
            EnumSupportExpressionFactoryWrapper exprFact = new EnumSupportExpressionFactoryWrapper(this.application.getExpressionFactory());
            Class<?> applicationClass = this.application.getClass();
            Field field = applicationClass.getDeclaredField("expressionFactory");
            field.setAccessible(true);
            field.set(this.application, (Object)exprFact);
            this.expressionFactory = this.application.getExpressionFactory();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.servletContext.addInitParameter("org.richfaces.SKIN", this.getSkinName());
        this.servletContext.addInitParameter("com.sun.faces.externalizeJavaScript", "true");
        RenderKitFactory vcpRenderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        this.vcpRenderKit = new ChameleonRenderKitImpl();
        vcpRenderKitFactory.addRenderKit("HTML_CHAMELEON", (RenderKit)this.vcpRenderKit);
        this.renderKit.addRenderer("javax.faces.ViewRoot", "javax.faces.ViewRoot", (Renderer)new AjaxViewRootRenderer());
        this.application.addComponent("javax.faces.ViewRoot", MockViewRoot.class.getName());
        this.ajaxContext = new AjaxContextImpl();
        this.request.setAttribute("ajaxContext", (Object)this.ajaxContext);
        this.application.setViewHandler((ViewHandler)new MockViewHandler(this.application.getViewHandler()));
        MockViewRoot root = new MockViewRoot();
        root.setViewId("/viewId");
        root.setRenderKitId("HTML_BASIC");
        this.facesContext.setViewRoot((UIViewRoot)root);
        this.servletContext.setAttribute("a4j", (Object)new VersionBean());
        this.servletContext.setAttribute("a4jSkin", (Object)new SkinBean());
        this.request.setPathElements("/testContext", "/faces", "/vievId.jsf", "");
        File webRoot = new File(((Object)((Object)this)).getClass().getResource("/WEB-INF/web.xml").getFile()).getParentFile().getParentFile();
        if (webRoot.exists()) {
            this.servletContext.setDocumentRoot(webRoot);
        } else {
            this.tmpRoot = File.createTempFile("TmpTestRoot" + new Random().nextInt(), null);
            this.tmpRoot.delete();
            this.tmpRoot.mkdir();
            this.servletContext.setDocumentRoot(this.tmpRoot);
            URL jarUrl = AbstractAjax4JsfTestCase.class.getProtectionDomain().getCodeSource().getLocation();
            ZipInputStream zis = new ZipInputStream(jarUrl.openStream());
            try {
                ZipEntry entry;
                byte[] buffer = new byte[8192];
                while ((entry = zis.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (!name.startsWith("WEB-INF/")) continue;
                    File out = new File(this.tmpRoot, name);
                    if (entry.isDirectory()) {
                        out.mkdirs();
                        continue;
                    }
                    out.getParentFile().mkdirs();
                    FileOutputStream os = new FileOutputStream(out);
                    try {
                        int count;
                        while ((count = zis.read(buffer)) > 0) {
                            ((OutputStream)os).write(buffer, 0, count);
                        }
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                    zis.closeEntry();
                }
            }
            catch (IOException e) {
                this.deleteRecursively(this.tmpRoot);
                throw e;
            }
            this.servletContext.setDocumentRoot(this.tmpRoot);
        }
        try {
            InternetResourceBuilder.getInstance().init();
        }
        catch (FacesException e) {
            InternetResourceBuilder.setInstance(null);
        }
        this.webXml = new WebXml();
        this.webXml.init((ServletContext)this.servletContext, "A4J");
        ConfigParser parser = new ConfigParser();
        parser.parse(parser.getPlatformURLs());
        Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources("META-INF/faces-config.xml");
        while (resources.hasMoreElements()) {
            parser.parse(resources.nextElement());
        }
        this.externalContext = new MockExternalContext(this.externalContext);
        this.facesContext.setExternalContext((ExternalContext)this.externalContext);
        this.elContext = this.facesContext.getELContext();
        this.expressionFactory = this.application.getExpressionFactory();
    }

    protected WebClient createWebClient() {
        WebClient client = new WebClient();
        client.setJavaScriptEnabled(true);
        client.setJavaScriptEngine((JavaScriptEngine)new DummyScriptEngine(client));
        return client;
    }

    protected InputStream getResourceIfPresent(String path) throws IOException {
        String uri;
        Page page;
        InternetResourceBuilder builder = ResourceBuilderImpl.getInstance();
        InternetResource resource = builder.getResource(path);
        if (resource != null && (page = this.webClient.getPage(uri = HTTP_PREFIX + resource.getUri((FacesContext)this.facesContext, null))).getWebResponse().getStatusCode() == 200) {
            return page.getWebResponse().getContentAsStream();
        }
        throw new IOException(RESOURCE_NOT_FOUND_MESSAGE + path);
    }

    protected ImageInfo getImageResource(String path) throws IOException {
        ImageInfo info = new ImageInfo();
        try {
            info.setInput(this.getResourceIfPresent(path));
        }
        catch (IOException e) {
            throw new IOException(IMAGE_NOT_FOUND_OR_UNAVAILABLE_MESSAGE + path);
        }
        return info.check() ? info : null;
    }

    protected Integer getCountValidScripts(HtmlPage view, Set<String> predefinedScripts, boolean isPageAvailabilityCheck) throws Exception {
        int foundCount = 0;
        List<String> scriptSources = HtmlTestUtils.extractScriptSources(view);
        block0: for (String javascript : predefinedScripts) {
            for (String script : scriptSources) {
                if (script.indexOf(javascript) < 0) continue;
                ++foundCount;
                String uri = HTTP_PREFIX + script;
                Page page = this.webClient.getPage(uri);
                if (!isPageAvailabilityCheck || page != null && page.getWebResponse().getStatusCode() == 200) continue block0;
                throw new Exception("Component script " + javascript + " is not found in the response");
            }
        }
        return foundCount;
    }

    protected void setupWebClient() {
        this.ajaxContext = null;
        this.webClient = this.createWebClient();
        this.webConnection = new MockWebConnection(this.webClient){

            public WebResponse getResponse(WebRequestSettings settings) throws IOException {
                String resourceKey = WebXml.getInstance((FacesContext)AbstractAjax4JsfTestCase.this.facesContext).getFacesResourceKey(settings.getURL().getFile().substring(AbstractAjax4JsfTestCase.this.request.getContextPath().length()));
                if (resourceKey != null) {
                    InternetResourceBuilder resourceBuilder = InternetResourceBuilder.getInstance();
                    InternetResource resource = resourceBuilder.getResourceForKey(resourceKey);
                    Object resourceData = resourceBuilder.getResourceDataForKey(resourceKey);
                    final MockFacesResourceContext resourceContext = new MockFacesResourceContext((FacesContext)AbstractAjax4JsfTestCase.this.facesContext);
                    resourceContext.setResourceData(resourceData);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    AbstractAjax4JsfTestCase.this.response.setOutputStream((ServletOutputStream)new MockServletOutputStream(baos));
                    resource.sendHeaders((ResourceContext)resourceContext);
                    resource.send((ResourceContext)resourceContext);
                    return new WebResponseImpl(new WebResponseData((InputStream)new ByteArrayInputStream(baos.toByteArray()), 200, "OK", resourceContext.getHeaders()), settings.getURL(), settings.getSubmitMethod(), 0L){

                        public String getContentType() {
                            return resourceContext.getContentType();
                        }
                    };
                }
                return super.getResponse(settings);
            }
        };
        this.webClient.setWebConnection((WebConnection)this.webConnection);
        this.webConnection.setDefaultResponse("<html><body>not found</body></html>", 404, "NOT FOUND", "text/html");
        this.webClient.setThrowExceptionOnFailingStatusCode(false);
        this.webClient.setThrowExceptionOnScriptError(false);
    }

    private void deleteRecursively(File file) {
        if (file != null) {
            String[] list = file.list();
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    String name = list[i];
                    File f = new File(file, name);
                    if (f.isDirectory()) {
                        this.deleteRecursively(f);
                        continue;
                    }
                    f.delete();
                }
            }
            file.delete();
        }
    }

    public void tearDown() throws Exception {
        this.expressionFactory = null;
        this.elContext = null;
        super.tearDown();
        this.vcpRenderKit = null;
        this.webClient = null;
        this.webConnection = null;
        this.writer = null;
        SkinFactory.reset();
        InternetResourceBuilder.setInstance(null);
        this.deleteRecursively(this.tmpRoot);
    }

    protected String getSkinName() {
        return "DEFAULT";
    }

    protected URL[] getImplementationUrls() {
        return new URL[0];
    }

    protected UIComponent createComponent(String type, String className, String rendererType, Class rendererClazz, Class skinRendererClazz) {
        Renderer renderer;
        UIComponent comp;
        try {
            comp = this.application.createComponent(type);
        }
        catch (FacesException e) {
            this.application.addComponent(type, className);
            comp = this.application.createComponent(type);
        }
        comp.setRendererType(rendererType);
        String family = comp.getFamily();
        if (null != rendererClazz && null == (renderer = this.renderKit.getRenderer(family, rendererType))) {
            try {
                renderer = (Renderer)rendererClazz.newInstance();
            }
            catch (InstantiationException e) {
                AbstractAjax4JsfTestCase.assertTrue((String)("Instantiation exception for create renderer " + rendererClazz.getName()), (boolean)false);
            }
            catch (IllegalAccessException e) {
                AbstractAjax4JsfTestCase.assertTrue((String)("ILEGAL access exception for create renderer " + rendererClazz.getName()), (boolean)false);
            }
            this.renderKit.addRenderer(family, rendererType, renderer);
        }
        if (null != skinRendererClazz && null == (renderer = this.renderKit.getRenderer(family, rendererType))) {
            try {
                renderer = (Renderer)skinRendererClazz.newInstance();
            }
            catch (InstantiationException e) {
                AbstractAjax4JsfTestCase.assertTrue((String)("Instantiation exception for create renderer " + skinRendererClazz.getName()), (boolean)false);
            }
            catch (IllegalAccessException e) {
                AbstractAjax4JsfTestCase.assertTrue((String)("ILEGAL access exception for create renderer " + skinRendererClazz.getName()), (boolean)false);
            }
            this.vcpRenderKit.addRenderer(family, rendererType, renderer);
        }
        comp.setId(this.facesContext.getViewRoot().createUniqueId());
        return comp;
    }

    protected void renderChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this.renderChild(context, child);
            }
        }
    }

    protected void renderChild(FacesContext context, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(context);
        if (child.getRendersChildren()) {
            child.encodeChildren(context);
        } else {
            this.renderChildren(context, child);
        }
        child.encodeEnd(context);
    }

    protected HtmlPage renderView() throws Exception {
        this.setupResponseWriter();
        TestXMLFilter filter = new TestXMLFilter();
        filter.processFilter(new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                response.setContentType("text/html");
                ResponseWriter responseWriter = AbstractAjax4JsfTestCase.this.renderKit.createResponseWriter((Writer)response.getWriter(), "text/html", null);
                UIViewRoot viewRoot = AbstractAjax4JsfTestCase.this.facesContext.getViewRoot();
                AbstractAjax4JsfTestCase.this.facesContext.setResponseWriter(responseWriter);
                AbstractAjax4JsfTestCase.this.encodeDocumentProlog((FacesContext)AbstractAjax4JsfTestCase.this.facesContext, viewRoot, responseWriter);
                ViewResources viewResources = new ViewResources();
                viewResources.initialize((FacesContext)AbstractAjax4JsfTestCase.this.facesContext);
                viewResources.setUseStdControlsSkinning(false);
                viewResources.setUseStdControlsSkinningClasses(false);
                AbstractAjax4JsfTestCase.this.renderChild((FacesContext)AbstractAjax4JsfTestCase.this.facesContext, (UIComponent)viewRoot);
                AbstractAjax4JsfTestCase.this.encodeDocumentEpilog((FacesContext)AbstractAjax4JsfTestCase.this.facesContext, viewRoot, responseWriter);
                viewResources.processHeadResources((FacesContext)AbstractAjax4JsfTestCase.this.facesContext);
                Object[] headEvents = viewResources.getHeadEvents();
                request.setAttribute("org.ajax4jsf.framework.HEAD_EVENTS_LIST", (Object)headEvents);
                AbstractAjax4JsfTestCase.this.facesContext.setResponseWriter((ResponseWriter)AbstractAjax4JsfTestCase.this.writer);
            }
        }, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        HtmlPage htmlPage = this.processResponseWriter();
        if (TestFileUtils.needXHTMLCheck()) {
            this.checkXHTML(htmlPage);
        }
        return htmlPage;
    }

    private void checkXHTML(HtmlPage htmlPage) throws ParserConfigurationException, IOException {
        String respons = htmlPage.getWebResponse().getContentAsString();
        int index = respons.lastIndexOf("<!DOCTYPE");
        String response = respons.substring(index);
        InputStream is = htmlPage.getWebResponse().getContentAsStream();
        byte[] b = new byte[response.length()];
        is.skip(index);
        is.read(b);
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        TestFileUtils.checkXHTML(new EntityResolverImpl(), response, stream);
    }

    protected void encodeDocumentXHTML11Prolog(FacesContext context, UIViewRoot viewRoot, ResponseWriter responseWriter) throws IOException {
        responseWriter.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        responseWriter.startElement("html", (UIComponent)viewRoot);
        responseWriter.writeAttribute("xmlns", (Object)"http://www.w3.org/1999/xhtml", null);
        responseWriter.startElement("head", (UIComponent)viewRoot);
        responseWriter.startElement("title", (UIComponent)viewRoot);
        responseWriter.writeText((Object)this.toString(), null);
        responseWriter.endElement("title");
        responseWriter.endElement("head");
        responseWriter.startElement("body", (UIComponent)viewRoot);
        responseWriter.writeText((Object)" ", null);
    }

    protected void encodeDocumentXHTML11Epilog(FacesContext context, UIViewRoot viewRoot, ResponseWriter responseWriter) throws IOException {
        responseWriter.endElement("body");
        responseWriter.endElement("html");
    }

    protected void encodeDocumentProlog(FacesContext context, UIViewRoot viewRoot, ResponseWriter writer) throws IOException {
        this.encodeDocumentXHTML11Prolog(context, viewRoot, writer);
    }

    protected void encodeDocumentEpilog(FacesContext context, UIViewRoot viewRoot, ResponseWriter writer) throws IOException {
        this.encodeDocumentXHTML11Epilog(context, viewRoot, writer);
    }

    protected HtmlPage processResponseWriter() throws IOException, Exception {
        this.writer.endDocument();
        return (HtmlPage)this.processResponse();
    }

    protected void setupResponseWriter() throws IOException {
        this.writer = (MockResponseWriter)this.renderKit.createResponseWriter((Writer)this.response.getWriter(), "text/html", null);
        this.facesContext.setResponseWriter((ResponseWriter)this.writer);
        this.writer.startDocument();
    }

    protected Page processResponse() throws Exception {
        this.setupWebClient();
        URL page = new URL(HTTP_PREFIX + this.facesContext.getExternalContext().getRequestContextPath() + this.facesContext.getViewRoot().getViewId());
        try {
            char[] content = ((MockPrintWriter)this.response.getWriter()).content();
            this.webConnection.setResponse(page, String.valueOf(content), this.response.getStatus(), "OK", this.response.getContentType(), Collections.EMPTY_LIST);
        }
        catch (IllegalStateException e) {
            byte[] content = ((MockServletOutputStream)this.response.getOutputStream()).content();
            this.webConnection.setResponse(page, content, this.response.getStatus(), "OK", this.response.getContentType(), Collections.EMPTY_LIST);
        }
        return this.webClient.getPage(page);
    }

    private class EntityResolverImpl
    implements EntityResolver {
        private EntityResolverImpl() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            try {
                ClassLoader contextClassLoader;
                URL resolvedUrl;
                URL url = new URL(systemId);
                if ("www.w3.org".equals(url.getHost()) && (resolvedUrl = (contextClassLoader = Thread.currentThread().getContextClassLoader()).getResource("META-INF/resources/w3c" + url.getPath())) != null) {
                    return new InputSource(URLToStreamHelper.urlToStream((URL)resolvedUrl));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            AbstractAjax4JsfTestCase.this.externalContext.log("Resource [" + publicId + " " + systemId + "] not found locally. Please add it to classpath for best performance");
            return null;
        }
    }

    private class TestXMLFilter
    extends BaseXMLFilter {
        private HtmlParser parser = null;

        public void processFilter(FilterChain chain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            super.doXmlFilter(chain, request, response);
        }

        protected HtmlParser getParser(String mimetype, boolean isAjax, String viewId) {
            HtmlParser parser = this.parser;
            if (parser == null) {
                parser = new FastHtmlParser();
            }
            return parser;
        }

        protected void reuseParser(HtmlParser parser) {
            this.parser = parser;
        }
    }
}

