/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.tests;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.FacesResourceContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceNotFoundException;

public class MockResourceHandler
extends ResourceHandler {
    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null);
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        StringBuilder path = new StringBuilder();
        if (libraryName != null) {
            path.append(libraryName);
        }
        if (libraryName.length() > 0) {
            path.append('/');
        }
        path.append(resourceName);
        InternetResourceBuilder resourceBuilder = InternetResourceBuilder.getInstance();
        try {
            final InternetResource resource = resourceBuilder.getResource(path.toString());
            return new Resource(){

                public boolean userAgentNeedsUpdate(FacesContext context) {
                    return true;
                }

                public URL getURL() {
                    throw new UnsupportedOperationException();
                }

                public Map<String, String> getResponseHeaders() {
                    return new HashMap<String, String>();
                }

                public String getRequestPath() {
                    return resource.getUri(FacesContext.getCurrentInstance(), null);
                }

                public InputStream getInputStream() throws IOException {
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    return resource.getResourceAsStream((ResourceContext)new FacesResourceContext(facesContext));
                }
            };
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public String getRendererTypeForResourceName(String resourceName) {
        if (resourceName.endsWith(".js")) {
            return "javax.faces.resource.Script";
        }
        if (resourceName.endsWith(".css")) {
            return "javax.faces.resource.Stylesheet";
        }
        return null;
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        throw new IllegalStateException();
    }

    public boolean isResourceRequest(FacesContext context) {
        return false;
    }

    public boolean libraryExists(String libraryName) {
        return true;
    }
}

