/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.tests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestFileUtils {
    private static final String ORG_AJAX4JSF_TEST_CHECK_XHTML_FILE = "org.ajax4jsf.test.checkXHTML.file";
    private static final String ORG_AJAX4JSF_TEST_CHECK_XHTML = "org.ajax4jsf.test.checkXHTML";
    private static final String CRLF = "\r\n";
    private static Boolean isCheckXHTML = null;
    private static String checkXHTMLOutputFile = null;
    private static boolean initialized = false;
    private static File testOutputFile = null;

    private TestFileUtils() {
        throw new UnsupportedOperationException();
    }

    static void checkXHTML(EntityResolver resolver, String response) {
        ArrayList<String> messagesList = new ArrayList<String>();
        try {
            DocumentBuilder documentBuilder = TestFileUtils.createDocumentBuilder();
            documentBuilder.setEntityResolver(resolver);
            TestFileUtils.setupBuilder(messagesList, documentBuilder);
            TestFileUtils.parseResponse(new InputSource(new StringReader(response)), documentBuilder);
            TestFileUtils.printXHTMLValidationError(response, messagesList);
        }
        catch (ParserConfigurationException pce) {
            System.err.println(pce.getLocalizedMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getLocalizedMessage());
        }
    }

    static void setupBuilder(final List<String> messagesList, DocumentBuilder documentBuilder) {
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                messagesList.add(exception.toString());
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                messagesList.add(exception.toString());
            }

            public void warning(SAXParseException exception) throws SAXException {
                messagesList.add(exception.toString());
            }
        });
    }

    static void initialize() {
        try {
            if (null == isCheckXHTML && (isCheckXHTML = Boolean.valueOf(Boolean.getBoolean(ORG_AJAX4JSF_TEST_CHECK_XHTML))).booleanValue()) {
                checkXHTMLOutputFile = System.getProperty(ORG_AJAX4JSF_TEST_CHECK_XHTML_FILE);
            }
            initialized = true;
        }
        catch (Exception e) {
            System.out.println("Security Manager error:");
            System.err.println(e.getLocalizedMessage());
        }
    }

    static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder;
    }

    private static void printErrors(String response, List<String> messagesList, OutputStreamWriter fw) throws IOException {
        fw.write(CRLF);
        if (!messagesList.isEmpty()) {
            fw.write(response);
            fw.write(CRLF);
            for (String string : messagesList) {
                fw.write(string);
                fw.write(CRLF);
            }
            fw.write(CRLF);
            fw.write(CRLF);
        }
    }

    static boolean needXHTMLCheck() {
        if (!initialized) {
            TestFileUtils.initialize();
        }
        return isCheckXHTML;
    }

    static void parseResponse(InputSource is, DocumentBuilder documentBuilder) {
        try {
            documentBuilder.parse(is);
        }
        catch (SAXException e) {
            System.err.println(e.getLocalizedMessage());
        }
        catch (IOException e) {
            System.err.println(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void printXHTMLValidationError(String response, List<String> messagesList) throws IOException {
        block7: {
            OutputStreamWriter fw = null;
            try {
                if (checkXHTMLOutputFile != null) {
                    if (null == testOutputFile) {
                        testOutputFile = new File(checkXHTMLOutputFile);
                        testOutputFile.createNewFile();
                    }
                    try {
                        fw = new FileWriter(testOutputFile, true);
                        TestFileUtils.printErrors(response, messagesList, fw);
                        break block7;
                    }
                    finally {
                        fw.close();
                    }
                }
                fw = new SystemOutWrapper(new ByteArrayOutputStream());
                TestFileUtils.printErrors(response, messagesList, fw);
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
            }
        }
    }

    private static class SystemOutWrapper
    extends OutputStreamWriter {
        private PrintStream writer;

        public SystemOutWrapper(OutputStream out) {
            super(out);
            this.setWrapper(System.out);
        }

        public void setWrapper(PrintStream out) {
            this.writer = out;
        }

        public void write(String message) {
            this.writer.println(message);
        }
    }
}

