/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.iconimages;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractJava2DUserResource;
import org.richfaces.resource.PostConstructResource;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public abstract class PanelIconBasic
extends AbstractJava2DUserResource
implements StateHolderResource {
    private static final Dimension DIMENSION = new Dimension(16, 48);
    private Color textColor;
    private Color headerColor;
    private Color disabledColor;

    protected PanelIconBasic() {
        super(DIMENSION);
    }

    public void paint(Graphics2D graphics2D) {
        if (this.textColor == null || this.headerColor == null || this.disabledColor == null || graphics2D == null) {
            return;
        }
        this.paintImage(graphics2D, this.textColor, this.headerColor, this.disabledColor);
    }

    protected abstract void paintImage(Graphics2D var1, Color var2, Color var3, Color var4);

    public boolean isTransient() {
        return false;
    }

    @PostConstructResource
    public void initialize() {
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance((FacesContext)context).getSkin(context);
        Skin defaultSkin = SkinFactory.getInstance((FacesContext)context).getDefaultSkin(context);
        this.textColor = this.getColor(context, skin, defaultSkin, "generalTextColor");
        this.headerColor = this.getColor(context, skin, defaultSkin, "headerTextColor");
        this.disabledColor = this.getColor(context, skin, defaultSkin, "tabDisabledTextColor");
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.textColor.getRGB());
        dataOutput.writeInt(this.headerColor.getRGB());
        dataOutput.writeInt(this.disabledColor.getRGB());
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
        this.textColor = new Color(dataInput.readInt());
        this.headerColor = new Color(dataInput.readInt());
        this.disabledColor = new Color(dataInput.readInt());
    }

    private Color getColor(FacesContext context, Skin skin, Skin defaultSkin, String colorString) {
        Integer colorParameter = skin.getColorParameter(context, colorString);
        if (colorParameter == null) {
            colorParameter = defaultSkin.getColorParameter(context, colorString);
        }
        return new Color(colorParameter);
    }
}

