/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceTracker {
    private static final String SERVICE_TRACKER_ATTRIBUTE = ServiceTracker.class.getName();
    private volatile Map<Class<?>, Object> servicesMap = new HashMap();
    private final Date startTime = new Date();
    private final ConcurrentMap<Object, Object> concurrentStorage = new ConcurrentHashMap<Object, Object>();

    private ServiceTracker() {
    }

    private <T> T get(Class<T> serviceClass) {
        Object serviceImplementation = null;
        Object serviceObject = this.servicesMap.get(serviceClass);
        serviceImplementation = serviceObject instanceof ServiceReference ? ((ServiceReference)serviceObject).getService() : serviceObject;
        return serviceClass.cast(serviceImplementation);
    }

    private void put(Class<?> key, Object value) {
        try {
            this.servicesMap.put(key, value);
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalStateException("Service tracker is locked, no modification operation is allowed!");
        }
    }

    private Collection<Class<?>> getRegisteredServiceClasses() {
        return Collections.unmodifiableCollection(this.servicesMap.keySet());
    }

    private synchronized void lockModification() {
        this.servicesMap = Collections.unmodifiableMap(this.servicesMap);
    }

    public static Collection<Class<?>> getRegisteredServiceClasses(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        ServiceTracker serviceTracker = ServiceTracker.getServiceTracker(context);
        return serviceTracker.getRegisteredServiceClasses();
    }

    public static <T> T getService(FacesContext context, Class<T> serviceClass) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        ServiceTracker serviceTracker = ServiceTracker.getServiceTracker(context);
        return serviceTracker.get(serviceClass);
    }

    public static <T> void setService(FacesContext context, Class<T> serviceClass, T serviceImplementation) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        if (serviceImplementation == null) {
            throw new NullPointerException("serviceImplementation");
        }
        ServiceTracker serviceTracker = ServiceTracker.getServiceTracker(context);
        serviceTracker.put(serviceClass, serviceImplementation);
    }

    public static <T> void setServiceReference(FacesContext context, Class<T> serviceClass, ServiceReference<T> serviceReference) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        if (serviceReference == null) {
            throw new NullPointerException("serviceReference");
        }
        ServiceTracker serviceTracker = ServiceTracker.getServiceTracker(context);
        serviceTracker.put(serviceClass, serviceReference);
    }

    public static void release(FacesContext context) {
        ServiceTracker.removeServiceTracker(context);
    }

    public static void lockModification(FacesContext context) {
        ServiceTracker serviceTracker = ServiceTracker.getServiceTracker(context);
        serviceTracker.lockModification();
    }

    public static Date getStartTime(FacesContext context) {
        return ServiceTracker.getServiceTracker((FacesContext)context).startTime;
    }

    public static ConcurrentMap<Object, Object> getConcurrentStorage(FacesContext context) {
        return ServiceTracker.getServiceTracker((FacesContext)context).concurrentStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceTracker getServiceTrackerFromApplicationMap(FacesContext facesContext) {
        Object appContext;
        Object object = appContext = facesContext.getExternalContext().getContext();
        synchronized (object) {
            Map applicationMap = facesContext.getExternalContext().getApplicationMap();
            ServiceTracker serviceTracker = (ServiceTracker)applicationMap.get(SERVICE_TRACKER_ATTRIBUTE);
            if (serviceTracker == null) {
                serviceTracker = new ServiceTracker();
                applicationMap.put(SERVICE_TRACKER_ATTRIBUTE, serviceTracker);
            }
            return serviceTracker;
        }
    }

    private static ServiceTracker getServiceTracker(FacesContext facesContext) {
        ServiceTracker serviceTracker = (ServiceTracker)facesContext.getAttributes().get(SERVICE_TRACKER_ATTRIBUTE);
        if (serviceTracker == null) {
            serviceTracker = ServiceTracker.getServiceTrackerFromApplicationMap(facesContext);
            facesContext.getAttributes().put(SERVICE_TRACKER_ATTRIBUTE, serviceTracker);
        }
        return serviceTracker;
    }

    private static void removeServiceTracker(FacesContext facesContext) {
        Map applicationMap = facesContext.getExternalContext().getApplicationMap();
        applicationMap.remove(SERVICE_TRACKER_ATTRIBUTE);
        facesContext.getAttributes().remove(SERVICE_TRACKER_ATTRIBUTE);
    }
}

