/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.ajax4jsf.Messages;
import org.richfaces.DataScrollerUtils;
import org.richfaces.component.UIDataAdaptor;
import org.richfaces.component.UIDataScroller;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTablePreRenderListener
implements SystemEventListener {
    private static final Logger LOG = RichfacesLogger.COMPONENTS.getLogger();

    public boolean isListenerForSource(Object source) {
        return source instanceof UIDataAdaptor || source instanceof UIData;
    }

    public UIDataScroller processActiveDatascroller(FacesContext facesContext, List<UIDataScroller> dataScrollers, UIComponent dataTable) {
        UIDataScroller activeComponent = null;
        ArrayList<Object> values = new ArrayList<Object>(dataScrollers.size());
        String stateKey = dataTable.getClientId(facesContext) + "org.richfaces.DataScroller:page";
        Map attributes = dataTable.getAttributes();
        Object pageValue = attributes.get(stateKey);
        boolean valid = true;
        if (pageValue == null) {
            for (UIDataScroller datascroller : dataScrollers) {
                Integer nextPageValue = null;
                if (datascroller.isLocalPageSet()) {
                    nextPageValue = datascroller.getPage();
                    attributes.put(stateKey, nextPageValue);
                    datascroller.resetLocalPage();
                } else {
                    nextPageValue = datascroller.getValueExpression("page");
                }
                if (!values.isEmpty() && !DataTablePreRenderListener.same(values.get(values.size() - 1), nextPageValue)) {
                    valid = false;
                }
                values.add(nextPageValue);
                if (nextPageValue == null) continue;
                activeComponent = datascroller;
            }
        }
        if (activeComponent == null) {
            activeComponent = dataScrollers.get(dataScrollers.size() - 1);
        }
        if (!valid) {
            String formattedMessage = this.getPageDifferentMessage(facesContext, activeComponent, dataScrollers, values);
            LOG.error(formattedMessage);
        }
        return activeComponent;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        UIComponent dataTable = (UIComponent)event.getSource();
        List<UIDataScroller> dataScrollers = DataScrollerUtils.findDataScrollers(dataTable);
        if (!dataScrollers.isEmpty()) {
            int first;
            String lastPageMode;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            UIDataScroller activeComponent = this.processActiveDatascroller(facesContext, dataScrollers, dataTable);
            int rowCount = DataScrollerUtils.getRowCount(dataTable);
            int rows = DataScrollerUtils.getRows(dataTable);
            Integer pageCount = DataScrollerUtils.getPageCount(dataTable, rowCount, rows);
            int page = activeComponent.getPage();
            int newPage = -1;
            if (page < 1) {
                newPage = 1;
            } else if (page > pageCount) {
                int n = newPage = pageCount != 0 ? pageCount : 1;
            }
            if (newPage != -1) {
                Object label = MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)activeComponent);
                String formattedMessage = Messages.getMessage((String)"DATASCROLLER_PAGE_MISSING", (Object[])new Object[]{label, page, pageCount, newPage});
                LOG.warn(formattedMessage);
                page = newPage;
                dataTable.getAttributes().put(dataTable.getClientId(facesContext) + "org.richfaces.DataScroller:page", page);
            }
            if ((lastPageMode = activeComponent.getLastPageMode()) == null) {
                lastPageMode = "short";
            } else if (!"short".equals(lastPageMode) && !"full".equals(lastPageMode)) {
                throw new IllegalArgumentException("Illegal value of 'lastPageMode' attribute: '" + lastPageMode + "'");
            }
            if (page != pageCount || "short".equals(lastPageMode)) {
                first = (page - 1) * rows;
            } else {
                first = rowCount - rows;
                if (first < 0) {
                    first = 0;
                }
            }
            dataTable.getAttributes().put("first", first);
        }
    }

    private String getPageDifferentMessage(FacesContext facesContext, UIDataScroller activeComponent, List<UIDataScroller> dataScrollers, List<Object> values) {
        StringBuilder builder = new StringBuilder("\n[");
        Iterator<UIDataScroller> scrollerItr = dataScrollers.iterator();
        Iterator<Object> valueItr = values.iterator();
        while (scrollerItr.hasNext()) {
            UIDataScroller next = scrollerItr.next();
            builder.append(MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)next));
            builder.append(": ");
            Object value = valueItr.next();
            if (value instanceof ValueExpression) {
                builder.append(((ValueExpression)value).getExpressionString());
            } else {
                builder.append(value);
            }
            builder.append(scrollerItr.hasNext() ? ",\n" : "]");
        }
        return Messages.getMessage((String)"DATASCROLLER_PAGES_DIFFERENT", (Object[])new Object[]{MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)activeComponent), builder});
    }

    private static boolean same(Object o1, Object o2) {
        if (o1 instanceof ValueExpression && o2 instanceof ValueExpression) {
            ValueExpression ve1 = (ValueExpression)o1;
            ValueExpression ve2 = (ValueExpression)o2;
            if (DataTablePreRenderListener.same(ve1.getExpressionString(), ve2.getExpressionString()) && DataTablePreRenderListener.same(ve1.getExpectedType(), ve2.getExpectedType())) {
                return true;
            }
        }
        return o1 != null && o1.equals(o2) || o1 == null && o2 == null;
    }
}

