/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.Row;
import org.richfaces.renderkit.RowHolder;
import org.richfaces.renderkit.SortingFilteringRowsRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableBaseRenderer
extends SortingFilteringRowsRenderer {
    public static final String ROW_CLASS_KEY = "rowClass";
    public static final String FIRST_ROW_CLASS_KEY = "firstRowClass";
    public static final String CELL_CLASS_KEY = "cellClass";
    public static final String CELL_ELEMENT_KEY = "cellElement";
    public static final String BREAK_ROW_BEFORE = "breakRowBefore";
    public static final String ROWSPAN_STRING = "rowspan";
    public static final String COLSPAN_STRING = "colspan";

    public void encodeColumn(FacesContext context, ResponseWriter writer, UIColumn component, RowHolder rowHolder) throws IOException {
        Map attributes;
        String parentId = rowHolder.getBaseClientId();
        if (component instanceof org.richfaces.component.UIColumn && Boolean.TRUE.equals((attributes = component.getAttributes()).get(BREAK_ROW_BEFORE)) && rowHolder.getProcessCell() != 0) {
            this.encodeRowEnd(writer);
            rowHolder.nextRow();
            rowHolder.setRowStart(true);
        }
        if (rowHolder.isRowStart()) {
            if (rowHolder.getCurrentRow() == 0) {
                this.encodeFirstRowStart(writer, context, parentId, (UIComponent)component);
            } else {
                this.encodeRowStart(writer, context, parentId, (UIComponent)component);
            }
            rowHolder.setRowStart(false);
        }
        this.encodeColumnStart(writer, context, parentId, (UIComponent)component);
        this.renderChildren(context, (UIComponent)component);
        this.encodeColumnEnd(writer, context, parentId);
        rowHolder.nextCell();
    }

    public void encodeColumnStart(ResponseWriter writer, FacesContext context, String parentId, UIComponent component) throws IOException {
        String element = this.getCellElement(context, parentId);
        writer.startElement(element, component);
        this.getUtils().encodeId(context, component);
        String cellClass = this.getCellClass(context, parentId);
        this.encodeStyleClass(writer, context, component, "styleClass", cellClass);
        if (component instanceof org.richfaces.component.UIColumn) {
            int colspan;
            Map attributes = component.getAttributes();
            int rowspan = (Integer)attributes.get(ROWSPAN_STRING);
            if (rowspan != Integer.MIN_VALUE) {
                writer.writeAttribute(ROWSPAN_STRING, (Object)rowspan, null);
            }
            if ((colspan = ((Integer)attributes.get(COLSPAN_STRING)).intValue()) != Integer.MIN_VALUE) {
                writer.writeAttribute(COLSPAN_STRING, (Object)colspan, null);
            }
        }
    }

    public void encodeColumnEnd(ResponseWriter writer, FacesContext context, String parentId) throws IOException {
        writer.endElement(this.getCellElement(context, parentId));
    }

    public void encodeFirstRowStart(ResponseWriter writer, FacesContext context, String parentId, UIComponent component) throws IOException {
        writer.startElement("tr", component);
        String styleClass = this.getFirstRowClass(context, parentId);
        this.encodeStyleClass(writer, context, component, "styleClass", styleClass);
    }

    public void encodeFirstRowEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
    }

    public void encodeRowStart(ResponseWriter writer, FacesContext context, String parentId, UIComponent component) throws IOException {
        writer.startElement("tr", component);
        String styleClass = this.getRowClass(context, parentId);
        this.encodeStyleClass(writer, context, component, "styleClass", styleClass);
    }

    public void encodeRowEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
    }

    protected String getFirstRowClass(FacesContext context, String id) {
        return this.get(context, id + FIRST_ROW_CLASS_KEY);
    }

    protected String getRowClass(FacesContext context, String id) {
        return this.get(context, id + ROW_CLASS_KEY);
    }

    protected String getCellClass(FacesContext context, String id) {
        return this.get(context, id + CELL_CLASS_KEY);
    }

    protected String getCellElement(FacesContext context, String id) {
        return this.get(context, id + CELL_ELEMENT_KEY);
    }

    private String get(FacesContext context, String key) {
        return (String)context.getAttributes().get(key);
    }

    protected void put(FacesContext context, String id, String key, String value) {
        context.getAttributes().put(id + key, value);
    }

    protected void saveRowStyles(FacesContext context, String id, String firstRowClass, String rowClass, String cellClass) {
        this.put(context, id, FIRST_ROW_CLASS_KEY, firstRowClass);
        this.put(context, id, ROW_CLASS_KEY, rowClass);
        this.put(context, id, CELL_CLASS_KEY, cellClass);
    }

    public void encodeStyleClass(ResponseWriter writer, FacesContext context, UIComponent component, String styleClassAttribute, String styleClass) throws IOException {
        boolean isEmpty = this.isEmptyAttr(component, styleClassAttribute);
        if (isEmpty && (styleClass == null || styleClass.trim().length() == 0)) {
            return;
        }
        String componentStyleClass = isEmpty ? styleClass : styleClass + " " + component.getAttributes().get(styleClassAttribute);
        writer.writeAttribute("class", (Object)componentStyleClass, null);
    }

    protected boolean isEmptyAttr(UIComponent component, String attribute) {
        if (attribute == null) {
            return true;
        }
        String value = (String)component.getAttributes().get(attribute);
        return value == null || value.trim().length() == 0;
    }

    protected void encodeStyle(ResponseWriter writer, FacesContext context, UIComponent component, String predefinedStyles) throws IOException {
        String style;
        StringBuffer toEncode = new StringBuffer();
        if (!this.isEmptyAttr(component, "style")) {
            style = ((String)component.getAttributes().get("style")).trim();
            style = style.endsWith(";") ? style : style + ";";
            toEncode.append(style);
        }
        if (!this.isEmpty(predefinedStyles)) {
            style = predefinedStyles.endsWith(";") ? predefinedStyles : predefinedStyles + ";";
            toEncode.append(style);
        }
        if (toEncode.length() > 0) {
            writer.writeAttribute("style", (Object)toEncode.toString(), null);
        }
    }

    protected boolean isEmpty(String style) {
        return style == null || style.trim().length() == 0;
    }

    protected int getColumnsCount(Iterator<UIComponent> col) {
        int count = 0;
        int currentLength = 0;
        while (col.hasNext()) {
            UIComponent component = col.next();
            if (!component.isRendered()) continue;
            if (component instanceof Row) {
                if (currentLength > count) {
                    count = currentLength;
                }
                if ((currentLength = this.getColumnsCount(((Row)component).columns())) > count) {
                    count = currentLength;
                }
                currentLength = 0;
                continue;
            }
            if (component instanceof org.richfaces.component.UIColumn) {
                Integer colspan;
                Map attributes = component.getAttributes();
                if (Boolean.TRUE.equals(attributes.get(BREAK_ROW_BEFORE))) {
                    if (currentLength > count) {
                        count = currentLength;
                    }
                    currentLength = 0;
                }
                if (null != (colspan = (Integer)attributes.get(COLSPAN_STRING)) && colspan != Integer.MIN_VALUE) {
                    currentLength += colspan.intValue();
                    continue;
                }
                ++currentLength;
                continue;
            }
            if (!(component instanceof UIColumn)) continue;
            ++currentLength;
        }
        if (currentLength > count) {
            count = currentLength;
        }
        return count;
    }
}

