/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.renderkit.AbstractTableBaseRenderer;
import org.richfaces.renderkit.HeaderEncodeStrategy;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.RowHolder;
import org.richfaces.renderkit.RowHolderBase;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js")})
public abstract class AbstractTableRenderer
extends AbstractTableBaseRenderer
implements MetaComponentRenderer {
    protected void doDecode(FacesContext context, UIComponent component) {
        this.decodeSortingFiltering(context, component);
    }

    protected void encodeRows(FacesContext facesContext, RowHolderBase rowHolder) {
        UIDataTableBase dataTableBase = (UIDataTableBase)rowHolder.getRow();
        String rowClass = this.getRowSkinClass();
        String cellClass = this.getCellSkinClass();
        String firstClass = this.getFirstRowSkinClass();
        rowClass = this.mergeStyleClasses("rowClass", rowClass, (UIComponent)dataTableBase);
        cellClass = this.mergeStyleClasses("cellClass", cellClass, (UIComponent)dataTableBase);
        firstClass = this.mergeStyleClasses("firstRowClass", firstClass, (UIComponent)dataTableBase);
        this.saveRowStyles(facesContext, dataTableBase.getClientId(facesContext), firstClass, rowClass, cellClass);
        super.encodeRows(facesContext, rowHolder);
    }

    public boolean isHeaderFactoryColumnAttributePresent(UIDataTableBase table, String attributeName) {
        Iterator<UIComponent> columns = table.columns();
        boolean result = false;
        while (columns.hasNext() && !result) {
            UIComponent component = columns.next();
            result = component.isRendered() && null != component.getValueExpression(attributeName);
        }
        return result;
    }

    protected boolean isEncodeHeaders(UIDataTableBase table) {
        return table.isColumnFacetPresent("header") || this.isHeaderFactoryColumnAttributePresent(table, "sortBy") || this.isHeaderFactoryColumnAttributePresent(table, "comparator") || this.isHeaderFactoryColumnAttributePresent(table, "filterBy");
    }

    protected int getColumnsCount(UIDataTableBase table) {
        Integer span = (Integer)table.getAttributes().get("columns");
        int count = null != span && span != Integer.MIN_VALUE ? span.intValue() : this.getColumnsCount(table.columns());
        return count;
    }

    public void encodeTableStructure(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
    }

    public void encodeBeforeRows(ResponseWriter writer, FacesContext facesContext, RowHolderBase holder) throws IOException {
        RowHolder rowHolder = (RowHolder)holder;
        Row row = rowHolder.getRow();
        if (this.encodeParentTBody((UIDataTableBase)row)) {
            if (rowHolder.isPartialUpdate()) {
                facesContext.getPartialViewContext().getPartialResponseWriter().startUpdate(row.getClientId(facesContext) + ":tb");
            }
            this.encodeTableBodyStart(writer, facesContext, (UIDataTableBase)row);
        }
    }

    public void encodeAfterRows(ResponseWriter writer, FacesContext facesContext, RowHolderBase holder) throws IOException {
        RowHolder rowHolder = (RowHolder)holder;
        Row row = rowHolder.getRow();
        if (this.encodeParentTBody((UIDataTableBase)row)) {
            this.encodeTableBodyEnd(writer);
            this.encodeHiddenContainer(writer, facesContext, (UIDataTableBase)row);
            if (rowHolder.isPartialUpdate()) {
                facesContext.getPartialViewContext().getPartialResponseWriter().endUpdate();
            }
        }
    }

    public abstract boolean encodeParentTBody(UIDataTableBase var1);

    public void encodeTableFacets(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
        Object key = dataTable.getRowKey();
        dataTable.captureOrigValue(context);
        dataTable.setRowKey(context, null);
        this.encodeTableStructure(writer, context, dataTable);
        this.setupTableStartElement(context, (UIComponent)dataTable);
        this.encodeHeaderFacet(writer, context, dataTable, false);
        this.encodeFooterFacet(writer, context, dataTable, false);
        dataTable.setRowKey(context, key);
        dataTable.restoreOrigValue(context);
    }

    public void encodeTableRows(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase, boolean encodePartialUpdate) throws IOException {
        this.put(facesContext, dataTableBase.getClientId(facesContext), "cellElement", "td");
        int rowCount = dataTableBase.getRowCount();
        if (rowCount > 0) {
            this.processRows(writer, facesContext, (UIComponent)dataTableBase, encodePartialUpdate);
        } else {
            String noDataTableBodyId = dataTableBase.getClientId(facesContext) + ":ndtb";
            if (encodePartialUpdate) {
                facesContext.getPartialViewContext().getPartialResponseWriter().startUpdate(noDataTableBodyId);
            }
            int columns = this.getColumnsCount(dataTableBase.columns());
            writer.startElement("tbody", (UIComponent)dataTableBase);
            writer.writeAttribute("id", (Object)noDataTableBodyId, null);
            writer.startElement("tr", (UIComponent)dataTableBase);
            writer.startElement("td", (UIComponent)dataTableBase);
            writer.writeAttribute("colspan", (Object)columns, null);
            String styleClass = (String)dataTableBase.getAttributes().get("noDataStyleClass");
            styleClass = styleClass != null ? this.getNoDataClass() + " " + styleClass : this.getNoDataClass();
            writer.writeAttribute("class", (Object)styleClass, null);
            UIComponent noDataFacet = dataTableBase.getNoData();
            if (noDataFacet != null && noDataFacet.isRendered()) {
                noDataFacet.encodeAll(facesContext);
            } else {
                String noDataLabel = dataTableBase.getNoDataLabel();
                if (noDataLabel != null) {
                    writer.writeText((Object)noDataLabel, "noDataLabel");
                }
            }
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tbody");
            if (encodePartialUpdate) {
                facesContext.getPartialViewContext().getPartialResponseWriter().endUpdate();
            }
        }
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (component instanceof UIDataTableBase) {
            this.encodeTableRows(writer, context, (UIDataTableBase)component, false);
        }
    }

    public void encodeTableStart(ResponseWriter writer, FacesContext context, UIDataTableBase component) throws IOException {
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(), null);
        String styleClass = this.getTableSkinClass();
        this.encodeStyleClass(writer, context, (UIComponent)component, "styleClass", styleClass);
    }

    protected void encodeHiddenContainer(ResponseWriter writer, FacesContext context, UIDataTableBase dataTableBase) throws IOException {
        writer.startElement("tbody", (UIComponent)dataTableBase);
        writer.writeAttribute("id", (Object)(dataTableBase.getClientId(context) + ":sc"), null);
        writer.writeAttribute("style", (Object)"display: none", null);
        writer.startElement("tr", (UIComponent)dataTableBase);
        writer.startElement("td", (UIComponent)dataTableBase);
        this.encodeClientScript(writer, context, dataTableBase);
        this.encodeHiddenInput(writer, context, dataTableBase);
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("tbody");
    }

    public void encodeTableEnd(ResponseWriter writer) throws IOException {
        writer.endElement("table");
    }

    public abstract void encodeClientScript(ResponseWriter var1, FacesContext var2, UIDataTableBase var3) throws IOException;

    public abstract void encodeHiddenInput(ResponseWriter var1, FacesContext var2, UIDataTableBase var3) throws IOException;

    public void encodeTableBodyStart(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
        writer.startElement("tbody", (UIComponent)dataTable);
        writer.writeAttribute("id", (Object)(dataTable.getClientId(context) + ":tb"), null);
        writer.writeAttribute("class", (Object)this.getTableSkinClass(), null);
        this.encodeStyle(writer, context, (UIComponent)dataTable, null);
    }

    public void encodeTableBodyEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tbody");
    }

    public abstract RowHolderBase createRowHolder(FacesContext var1, UIComponent var2);

    public void encodeFooterFacet(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable, boolean encodePartialUpdate) throws IOException {
        UIComponent footer = dataTable.getFooter();
        boolean columnFacetPresent = dataTable.isColumnFacetPresent("footer");
        if (footer != null && footer.isRendered() || columnFacetPresent) {
            String firstClass;
            String cellClass;
            String rowClass;
            boolean encodePartialUpdateForChildren;
            boolean partialUpdateEncoded = false;
            boolean encodeTfoot = this.containsThead();
            if (encodeTfoot) {
                String footerClientId = dataTable.getClientId(context) + ":tf";
                if (encodePartialUpdate) {
                    partialUpdateEncoded = true;
                    context.getPartialViewContext().getPartialResponseWriter().startUpdate(footerClientId);
                }
                writer.startElement("tfoot", (UIComponent)dataTable);
                writer.writeAttribute("id", (Object)footerClientId, null);
                writer.writeAttribute("class", (Object)"rich-table-tfoot", null);
            }
            int columns = this.getColumnsCount(dataTable);
            String id = dataTable.getClientId(context);
            boolean bl = encodePartialUpdateForChildren = encodePartialUpdate && !partialUpdateEncoded;
            if (columnFacetPresent) {
                rowClass = this.getColumnFooterSkinClass();
                cellClass = this.getColumnFooterCellSkinClass();
                firstClass = this.getColumnFooterFirstSkinClass();
                rowClass = this.mergeStyleClasses("columnFooterClass", rowClass, (UIComponent)dataTable);
                cellClass = this.mergeStyleClasses("columnFooterCellClass", cellClass, (UIComponent)dataTable);
                firstClass = this.mergeStyleClasses("firstColumnFooterClass", firstClass, (UIComponent)dataTable);
                this.saveRowStyles(context, id, firstClass, rowClass, cellClass);
                String targetId = id + ":cf";
                if (encodePartialUpdateForChildren) {
                    context.getPartialViewContext().getPartialResponseWriter().startUpdate(targetId);
                }
                writer.startElement("tr", (UIComponent)dataTable);
                writer.writeAttribute("id", (Object)targetId, null);
                this.encodeStyleClass(writer, context, (UIComponent)dataTable, null, rowClass);
                this.encodeColumnFacet(context, writer, dataTable, "footer", columns, cellClass);
                writer.endElement("tr");
                if (encodePartialUpdateForChildren) {
                    context.getPartialViewContext().getPartialResponseWriter().endUpdate();
                }
            }
            if (footer != null && footer.isRendered()) {
                rowClass = this.getFooterSkinClass();
                cellClass = this.getFooterCellSkinClass();
                firstClass = this.getFooterFirstSkinClass();
                rowClass = this.mergeStyleClasses("footerClass", rowClass, (UIComponent)dataTable);
                cellClass = this.mergeStyleClasses("footerCellClass", cellClass, (UIComponent)dataTable);
                firstClass = this.mergeStyleClasses("footerFirstClass", firstClass, (UIComponent)dataTable);
                this.saveRowStyles(context, id, firstClass, rowClass, cellClass);
                this.encodeTableFacet(context, writer, id, columns, footer, "footer", rowClass, cellClass, encodePartialUpdateForChildren);
            }
            if (encodeTfoot) {
                writer.endElement("tfoot");
                if (partialUpdateEncoded) {
                    context.getPartialViewContext().getPartialResponseWriter().endUpdate();
                }
            }
        }
    }

    protected String mergeStyleClasses(String classAttribibute, String skinClass, UIComponent component) {
        String styleClass = null;
        String resultClass = skinClass;
        if (classAttribibute != null && component != null) {
            styleClass = (String)component.getAttributes().get(classAttribibute);
        }
        if (styleClass != null && styleClass.trim().length() > 0) {
            resultClass = resultClass + " " + styleClass;
        }
        return resultClass;
    }

    public void encodeHeaderFacet(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable, boolean encodePartialUpdate) throws IOException {
        UIComponent header = dataTable.getHeader();
        boolean isEncodeHeaders = this.isEncodeHeaders(dataTable);
        boolean encodeThead = this.containsThead();
        if (header != null && header.isRendered() || isEncodeHeaders) {
            String firstClass;
            String cellClass;
            String rowClass;
            boolean encodePartialUpdateForChildren;
            boolean partialUpdateEncoded = false;
            if (encodeThead) {
                String headerClientId = dataTable.getClientId(context) + ":th";
                if (encodePartialUpdate) {
                    partialUpdateEncoded = true;
                    context.getPartialViewContext().getPartialResponseWriter().startUpdate(headerClientId);
                }
                writer.startElement("thead", (UIComponent)dataTable);
                writer.writeAttribute("id", (Object)headerClientId, null);
                writer.writeAttribute("class", (Object)"rich-table-thead", null);
            }
            int columns = this.getColumnsCount(dataTable);
            String id = dataTable.getClientId(context);
            boolean bl = encodePartialUpdateForChildren = encodePartialUpdate && !partialUpdateEncoded;
            if (header != null && header.isRendered()) {
                rowClass = this.getHeaderSkinClass();
                cellClass = this.getHeaderCellSkinClass();
                firstClass = this.getHeaderFirstSkinClass();
                rowClass = this.mergeStyleClasses("headerClass", rowClass, (UIComponent)dataTable);
                cellClass = this.mergeStyleClasses("headerCellClass", cellClass, (UIComponent)dataTable);
                firstClass = this.mergeStyleClasses("headerFirstClass", firstClass, (UIComponent)dataTable);
                this.saveRowStyles(context, id, firstClass, rowClass, cellClass);
                this.encodeTableFacet(context, writer, id, columns, header, "header", rowClass, cellClass, encodePartialUpdateForChildren);
            }
            if (isEncodeHeaders) {
                rowClass = this.getColumnHeaderSkinClass();
                cellClass = this.getColumnHeaderCellSkinClass();
                firstClass = this.getColumnHeaderFirstSkinClass();
                rowClass = this.mergeStyleClasses("columnHeaderClass", rowClass, (UIComponent)dataTable);
                cellClass = this.mergeStyleClasses("columnHeaderCellClass", cellClass, (UIComponent)dataTable);
                firstClass = this.mergeStyleClasses("columnHeaderFirstClass", firstClass, (UIComponent)dataTable);
                this.saveRowStyles(context, id, firstClass, rowClass, cellClass);
                String targetId = id + ":ch";
                if (encodePartialUpdateForChildren) {
                    context.getPartialViewContext().getPartialResponseWriter().startUpdate(targetId);
                }
                writer.startElement("tr", (UIComponent)dataTable);
                writer.writeAttribute("id", (Object)targetId, null);
                this.encodeStyleClass(writer, context, (UIComponent)dataTable, null, rowClass);
                this.encodeColumnFacet(context, writer, dataTable, "header", columns, cellClass);
                writer.endElement("tr");
                if (encodePartialUpdateForChildren) {
                    context.getPartialViewContext().getPartialResponseWriter().endUpdate();
                }
            }
            if (encodeThead) {
                writer.endElement("thead");
                if (partialUpdateEncoded) {
                    context.getPartialViewContext().getPartialResponseWriter().endUpdate();
                }
            }
        }
    }

    protected void encodeColumnFacet(FacesContext context, ResponseWriter writer, UIDataTableBase dataTableBase, String facetName, int colCount, String cellClass) throws IOException {
        int tColCount = 0;
        String id = dataTableBase.getClientId(context);
        String element = this.getCellElement(context, id);
        Iterator<UIComponent> headers = dataTableBase.columns();
        while (headers.hasNext()) {
            UIComponent column = headers.next();
            if (!column.isRendered()) continue;
            Integer colspan = (Integer)column.getAttributes().get("colspan");
            tColCount = colspan != null && colspan > 0 ? (tColCount += colspan.intValue()) : ++tColCount;
            if (tColCount > colCount) break;
            writer.startElement(element, column);
            this.encodeStyleClass(writer, context, column, null, cellClass);
            writer.writeAttribute("scope", (Object)"col", null);
            this.getUtils().encodeAttribute(context, column, "colspan");
            HeaderEncodeStrategy strategy = this.getHeaderEncodeStrategy(column, facetName);
            if (strategy != null) {
                strategy.encodeBegin(context, writer, column, facetName);
                UIComponent facet = column.getFacet(facetName);
                if (facet != null && facet.isRendered()) {
                    facet.encodeAll(context);
                }
                strategy.encodeEnd(context, writer, column, facetName);
            }
            writer.endElement(element);
        }
    }

    protected void encodeTableFacet(FacesContext context, ResponseWriter writer, String id, int columns, UIComponent footer, String facetName, String rowClass, String cellClass, boolean encodePartialUpdate) throws IOException {
        boolean isColumnGroup = footer instanceof Row;
        String element = this.getCellElement(context, id);
        boolean partialUpdateEncoded = false;
        if (!isColumnGroup) {
            String targetId = id + ":" + facetName.charAt(0);
            if (encodePartialUpdate) {
                partialUpdateEncoded = true;
                context.getPartialViewContext().getPartialResponseWriter().startUpdate(targetId);
            }
            writer.startElement("tr", footer);
            writer.writeAttribute("id", (Object)targetId, null);
            this.encodeStyleClass(writer, context, footer, null, rowClass);
            writer.startElement(element, footer);
            this.encodeStyleClass(writer, context, footer, null, cellClass);
            if (columns > 0) {
                writer.writeAttribute("colspan", (Object)String.valueOf(columns), null);
            }
            writer.writeAttribute("scope", (Object)"colgroup", null);
        }
        if (encodePartialUpdate && !partialUpdateEncoded) {
            context.getPartialViewContext().getPartialResponseWriter().startUpdate(footer.getClientId(context));
        }
        footer.encodeAll(context);
        if (encodePartialUpdate && !partialUpdateEncoded) {
            context.getPartialViewContext().getPartialResponseWriter().endUpdate();
        }
        if (!isColumnGroup) {
            writer.endElement(element);
            writer.endElement("tr");
            if (partialUpdateEncoded) {
                context.getPartialViewContext().getPartialResponseWriter().endUpdate();
            }
        }
    }

    public abstract HeaderEncodeStrategy getHeaderEncodeStrategy(UIComponent var1, String var2);

    public abstract boolean containsThead();

    public abstract String getTableSkinClass();

    public abstract String getFirstRowSkinClass();

    public abstract String getRowSkinClass();

    public abstract String getHeaderCellSkinClass();

    public abstract String getHeaderSkinClass();

    public abstract String getHeaderFirstSkinClass();

    public abstract String getColumnHeaderCellSkinClass();

    public abstract String getColumnHeaderSkinClass();

    public abstract String getColumnHeaderFirstSkinClass();

    public abstract String getFooterCellSkinClass();

    public abstract String getFooterSkinClass();

    public abstract String getFooterFirstSkinClass();

    public abstract String getColumnFooterCellSkinClass();

    public abstract String getColumnFooterSkinClass();

    public abstract String getColumnFooterFirstSkinClass();

    public abstract String getCellSkinClass();

    public abstract String getNoDataClass();

    protected abstract void setupTableStartElement(FacesContext var1, UIComponent var2);

    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        UIDataTableBase table = (UIDataTableBase)component;
        this.setupTableStartElement(context, component);
        if ("header".equals(metaComponentId)) {
            this.encodeHeaderFacet(context.getResponseWriter(), context, table, true);
        } else if ("footer".equals(metaComponentId)) {
            this.encodeFooterFacet(context.getResponseWriter(), context, table, true);
        } else if ("body".equals(metaComponentId)) {
            this.encodeTableRows(context.getResponseWriter(), context, table, true);
        } else {
            throw new IllegalArgumentException("Unsupported metaComponentIdentifier: " + metaComponentId);
        }
    }

    protected class SimpleHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected SimpleHeaderEncodeStrategy() {
        }

        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent column, String facetName) throws IOException {
        }

        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent column, String facetName) throws IOException {
        }
    }
}

