/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.renderkit.AjaxEventOptions;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTable;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.renderkit.AbstractTableRenderer;
import org.richfaces.renderkit.HeaderEncodeStrategy;
import org.richfaces.renderkit.RowHolder;
import org.richfaces.renderkit.RowHolderBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(name="datatable.js"), @ResourceDependency(name="datatable.ecss")})
public class DataTableRenderer
extends AbstractTableRenderer {
    @Override
    public void encodeTableStructure(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
        if (dataTable instanceof UIDataTable) {
            this.encodeCaption(writer, context, (UIDataTable)dataTable);
            writer.startElement("colgroup", (UIComponent)dataTable);
            int columns = this.getColumnsCount(dataTable);
            writer.writeAttribute("span", (Object)String.valueOf(columns), null);
            String columnsWidth = (String)dataTable.getAttributes().get("columnsWidth");
            if (null != columnsWidth) {
                String[] widths = columnsWidth.split(",");
                for (int i = 0; i < widths.length; ++i) {
                    writer.startElement("col", (UIComponent)dataTable);
                    writer.writeAttribute("width", (Object)widths[i], null);
                    writer.endElement("col");
                }
            }
            writer.endElement("colgroup");
        }
    }

    @Override
    public RowHolder createRowHolder(FacesContext context, UIComponent component) {
        return new RowHolder(context, (UIDataTable)component);
    }

    @Override
    public void encodeRow(ResponseWriter writer, FacesContext context, RowHolderBase holder) throws IOException {
        RowHolder rowHolder = (RowHolder)holder;
        Row row = rowHolder.getRow();
        if (!this.encodeParentTBody((UIDataTable)row)) {
            if (rowHolder.isPartialUpdate()) {
                context.getPartialViewContext().getPartialResponseWriter().startUpdate(((UIDataTable)row).getClientId() + ":tb");
            }
            this.encodeTableBodyStart(writer, context, (UIDataTable)row);
        }
        rowHolder.setRowStart(true);
        Iterator components = row.columns();
        boolean isTRopen = false;
        while (components.hasNext()) {
            UIComponent child = (UIComponent)components.next();
            if (child instanceof Row) {
                if (rowHolder.getProcessCell() != 0) {
                    this.encodeRowEnd(writer);
                    isTRopen = false;
                    this.encodeTableBodyEnd(writer);
                    if (rowHolder.isPartialUpdate()) {
                        context.getPartialViewContext().getPartialResponseWriter().endUpdate();
                    }
                }
                rowHolder.nextCell();
                if (rowHolder.isPartialUpdate()) {
                    context.getPartialViewContext().getPartialResponseWriter().startUpdate(child.getClientId());
                }
                child.encodeAll(context);
                if (!rowHolder.isPartialUpdate()) continue;
                context.getPartialViewContext().getPartialResponseWriter().endUpdate();
                continue;
            }
            if (!(child instanceof UIColumn)) continue;
            this.encodeColumn(context, writer, (UIColumn)child, rowHolder);
            isTRopen = true;
        }
        if (isTRopen) {
            this.encodeRowEnd(writer);
        }
    }

    @Override
    public boolean encodeParentTBody(UIDataTableBase dataTableBase) {
        Iterator<UIComponent> iterator = dataTableBase.columns();
        while (iterator.hasNext()) {
            UIComponent child = iterator.next();
            if (!(child instanceof Row)) continue;
            return false;
        }
        return true;
    }

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (!this.shouldProceed(component)) {
            return;
        }
        UIDataTableBase dataTable = (UIDataTableBase)component;
        this.encodeTableStart(writer, context, dataTable);
        this.encodeTableFacets(writer, context, dataTable);
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (!this.shouldProceed(component)) {
            return;
        }
        if (component instanceof UIDataTable) {
            this.encodeTableEnd(writer);
        }
    }

    protected boolean shouldProceed(UIComponent component) {
        return component instanceof UIDataTableBase;
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIDataTable.class;
    }

    public void encodeCaption(ResponseWriter writer, FacesContext context, UIDataTable dataTable) throws IOException {
        UIComponent caption = dataTable.getCaption();
        if (caption == null) {
            return;
        }
        if (!caption.isRendered()) {
            return;
        }
        writer.startElement("caption", (UIComponent)dataTable);
        String captionClass = (String)dataTable.getAttributes().get("captionClass");
        String captionSkinClass = this.getCaptionSkinClass();
        captionClass = captionClass != null ? captionClass + " " + captionClass : captionSkinClass;
        writer.writeAttribute("class", (Object)captionClass, "captionClass");
        String captionStyle = (String)dataTable.getAttributes().get("captionStyle");
        if (captionStyle != null && captionStyle.trim().length() != 0) {
            writer.writeAttribute("style", (Object)captionStyle, "captionStyle");
        }
        caption.encodeAll(context);
        writer.endElement("caption");
    }

    @Override
    public HeaderEncodeStrategy getHeaderEncodeStrategy(UIComponent column, String tableFacetName) {
        return column instanceof org.richfaces.component.UIColumn && "header".equals(tableFacetName) ? new RichHeaderEncodeStrategy() : new AbstractTableRenderer.SimpleHeaderEncodeStrategy();
    }

    @Override
    public boolean containsThead() {
        return true;
    }

    public boolean isSortable(UIColumn column) {
        if (column instanceof org.richfaces.component.UIColumn) {
            return ((org.richfaces.component.UIColumn)column).getValueExpression("sortBy") != null;
        }
        return false;
    }

    @Override
    public void encodeClientScript(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase) throws IOException {
        UIDataTable dataTable = (UIDataTable)dataTableBase;
        writer.startElement("script", (UIComponent)dataTable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSFunction function = new JSFunction("new RichFaces.ui.DataTable", new Object[0]);
        function.addParameter((Object)dataTable.getClientId(facesContext));
        HashMap<String, Map> options = new HashMap<String, Map>();
        AjaxEventOptions ajaxEventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)facesContext, (UIComponent)dataTable);
        options.put("ajaxEventOptions", ajaxEventOptions.getParameters());
        function.addParameter(options);
        writer.writeText((Object)function.toScript(), null);
        writer.endElement("script");
    }

    @Override
    public void encodeHiddenInput(ResponseWriter writer, FacesContext context, UIDataTableBase component) throws IOException {
    }

    @Override
    public String getTableSkinClass() {
        return "rf-dt";
    }

    public String getCaptionSkinClass() {
        return "rf-dt-cap";
    }

    @Override
    public String getRowSkinClass() {
        return "rf-dt-r";
    }

    @Override
    public String getFirstRowSkinClass() {
        return "rf-dt-f-r";
    }

    @Override
    public String getCellSkinClass() {
        return "rf-dt-c";
    }

    @Override
    public String getHeaderSkinClass() {
        return "rf-dt-h";
    }

    @Override
    public String getHeaderFirstSkinClass() {
        return "rf-dt-h-f";
    }

    @Override
    public String getHeaderCellSkinClass() {
        return "rf-dt-h-c";
    }

    @Override
    public String getColumnHeaderSkinClass() {
        return "rf-dt-sh";
    }

    @Override
    public String getColumnHeaderFirstSkinClass() {
        return "rf-dt-sh-f";
    }

    @Override
    public String getColumnHeaderCellSkinClass() {
        return "rf-dt-sh-c";
    }

    @Override
    public String getColumnFooterSkinClass() {
        return "rf-dt-sf";
    }

    @Override
    public String getColumnFooterFirstSkinClass() {
        return "rf-dt-sf-f";
    }

    @Override
    public String getColumnFooterCellSkinClass() {
        return "rf-dt-sf-c";
    }

    @Override
    public String getFooterSkinClass() {
        return "rf-dt-f";
    }

    @Override
    public String getFooterFirstSkinClass() {
        return "rf-dt-f-f";
    }

    @Override
    public String getFooterCellSkinClass() {
        return "rf-dt-f-c";
    }

    @Override
    public String getNoDataClass() {
        return "rf-dt-nd-c";
    }

    @Override
    protected void setupTableStartElement(FacesContext context, UIComponent component) {
        this.put(context, component.getClientId(context), "cellElement", "th");
    }

    protected class RichHeaderEncodeStrategy
    implements HeaderEncodeStrategy {
        protected RichHeaderEncodeStrategy() {
        }

        public void encodeBegin(FacesContext context, ResponseWriter writer, UIComponent component, String facetName) throws IOException {
            org.richfaces.component.UIColumn column = (org.richfaces.component.UIColumn)component;
            writer.writeAttribute("id", (Object)column.getClientId(context), null);
            boolean sortableColumn = DataTableRenderer.this.isSortable(column);
            if (sortableColumn) {
                writer.startElement("span", (UIComponent)column);
                writer.writeAttribute("class", (Object)"rich-table-sortable-header", null);
            }
        }

        public void encodeEnd(FacesContext context, ResponseWriter writer, UIComponent component, String facetName) throws IOException {
            org.richfaces.component.UIColumn column = (org.richfaces.component.UIColumn)component;
            if (DataTableRenderer.this.isSortable(column)) {
                writer.endElement("span");
            }
        }

        public void encodeSortControls(FacesContext context, ResponseWriter writer, org.richfaces.component.UIColumn column, boolean enableAsc, boolean enableDesc, boolean enableUnsort) throws IOException {
        }
    }
}

