/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.swing.SortOrder;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.model.SortMode;
import org.richfaces.renderkit.AbstractRowsRenderer;

public abstract class SortingFilteringRowsRenderer
extends AbstractRowsRenderer {
    private static final String FILTERING_STRING = "rich:filtering";
    private static final String SORTING_STRING = "rich:sorting";
    private static final String FILTER_VALUE_STRING = "filterValue";
    private static final String SORT_ORDER_STRING = "sortOrder";
    private static final String SORT_PRIORITY_STRING = "sortPriority";
    private static final String SEPARATOR = ":";

    protected void decodeSortingFiltering(FacesContext context, UIComponent component) {
        if (component instanceof UIDataTableBase) {
            String sorting;
            String clientId;
            UIDataTableBase dataTableBase = (UIDataTableBase)component;
            Map requestMap = context.getExternalContext().getRequestParameterMap();
            String filtering = (String)requestMap.get((clientId = dataTableBase.getClientId(context)) + FILTERING_STRING);
            if (filtering != null && filtering.trim().length() > 0) {
                this.decodeFiltering(context, dataTableBase, filtering);
            }
            if ((sorting = (String)requestMap.get(clientId + SORTING_STRING)) != null && sorting.trim().length() > 0) {
                this.decodeSorting(context, dataTableBase, sorting);
            }
        }
    }

    protected void decodeFiltering(FacesContext context, UIDataTableBase dataTableBase, String value) {
        String[] values = value.split(SEPARATOR);
        if (Boolean.parseBoolean(values[2])) {
            Iterator<UIComponent> iterator = dataTableBase.columns();
            while (iterator.hasNext()) {
                UIComponent column = iterator.next();
                if (values[0].equals(column.getId())) {
                    this.updateAttribute(context, column, FILTER_VALUE_STRING, values[1]);
                    continue;
                }
                this.updateAttribute(context, column, FILTER_VALUE_STRING, null);
            }
        } else {
            this.updateAttribute(context, dataTableBase.findComponent(values[0]), FILTER_VALUE_STRING, values[1]);
        }
        context.getPartialViewContext().getRenderIds().add(dataTableBase.getClientId(context));
    }

    protected void decodeSorting(FacesContext context, UIDataTableBase dataTableBase, String value) {
        LinkedList<String> sortPriority = new LinkedList<String>();
        String[] values = value.split(SEPARATOR);
        if (Boolean.parseBoolean(values[2]) || SortMode.single.equals((Object)dataTableBase.getSortMode())) {
            Iterator<UIComponent> iterator = dataTableBase.columns();
            while (iterator.hasNext()) {
                UIComponent column = iterator.next();
                if (values[0].equals(column.getId())) {
                    this.updateSortOrder(context, column, values[1]);
                    sortPriority.add(values[0]);
                    continue;
                }
                this.updateAttribute(context, column, SORT_ORDER_STRING, (Object)SortOrder.UNSORTED);
            }
        } else {
            this.updateSortOrder(context, dataTableBase.findComponent(values[0]), values[1]);
            Collection<?> priority = dataTableBase.getSortPriority();
            if (priority != null) {
                priority.remove(values[0]);
                sortPriority.addAll(priority);
            }
            sortPriority.add(values[0]);
        }
        this.updateAttribute(context, (UIComponent)dataTableBase, SORT_PRIORITY_STRING, sortPriority);
        context.getPartialViewContext().getRenderIds().add(dataTableBase.getClientId(context));
    }

    private void updateSortOrder(FacesContext context, UIComponent component, String value) {
        SortOrder sortOrder;
        block2: {
            sortOrder = SortOrder.ASCENDING;
            try {
                sortOrder = SortOrder.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                if (!SortOrder.ASCENDING.equals(component.getAttributes().get(SORT_ORDER_STRING))) break block2;
                sortOrder = SortOrder.DESCENDING;
            }
        }
        this.updateAttribute(context, component, SORT_ORDER_STRING, (Object)sortOrder);
    }

    protected void updateAttribute(FacesContext context, UIComponent component, String attribute, Object value) {
        Object oldValue = component.getAttributes().get(attribute);
        if (oldValue != null && !oldValue.equals(value) || oldValue == null && value != null) {
            ELContext elContext = context.getELContext();
            ValueExpression ve = component.getValueExpression(attribute);
            if (ve != null && !ve.isReadOnly(elContext)) {
                component.getAttributes().put(attribute, null);
                try {
                    ve.setValue(elContext, value);
                }
                catch (ELException e) {
                    throw new FacesException((Throwable)e);
                }
            } else {
                component.getAttributes().put(attribute, value);
            }
        }
    }
}

