/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.component.Row;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.component.UISubTable;
import org.richfaces.event.ToggleEvent;
import org.richfaces.renderkit.AbstractTableRenderer;
import org.richfaces.renderkit.HeaderEncodeStrategy;
import org.richfaces.renderkit.RowHolder;
import org.richfaces.renderkit.RowHolderBase;

public class SubTableRenderer
extends AbstractTableRenderer {
    private static final String STATE = ":state";
    private static final String OPTIONS = ":options";

    protected void doDecode(FacesContext facesContext, UIComponent component) {
        UISubTable subTable = (UISubTable)component;
        String clientId = subTable.getClientId(facesContext);
        String stateId = clientId + STATE;
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String state = (String)requestMap.get(stateId);
        boolean isExpand = true;
        if (state != null) {
            int newValue = Integer.parseInt(state);
            if (newValue < 1) {
                isExpand = false;
            }
            if (subTable.isExpanded() != isExpand) {
                new ToggleEvent((UIComponent)subTable, isExpand).queue();
            }
        }
    }

    public void encodeTableFacets(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
        UISubTable subTable = (UISubTable)dataTable;
        this.encodeHeaderFacet(writer, context, subTable, false);
        String rowClass = this.getRowSkinClass();
        String cellClass = this.getCellSkinClass();
        String firstClass = this.getFirstRowSkinClass();
        rowClass = this.mergeStyleClasses("rowClass", rowClass, (UIComponent)subTable);
        cellClass = this.mergeStyleClasses("cellClass", cellClass, (UIComponent)subTable);
        firstClass = this.mergeStyleClasses("firstRowClass", firstClass, (UIComponent)subTable);
        this.saveRowStyles(context, subTable.getClientId(context), firstClass, rowClass, cellClass);
    }

    public void encodeTableBodyStart(ResponseWriter writer, FacesContext context, UIDataTableBase dataTable) throws IOException {
        UISubTable subTable = (UISubTable)dataTable;
        writer.startElement("tbody", (UIComponent)subTable);
        this.getUtils().encodeId(context, (UIComponent)subTable);
        String predefinedStyles = !subTable.isExpanded() ? "display: none;" : null;
        writer.writeAttribute("class", (Object)this.getTableSkinClass(), null);
        this.encodeStyle(writer, context, (UIComponent)dataTable, predefinedStyles);
    }

    public RowHolderBase createRowHolder(FacesContext context, UIComponent component) {
        return new RowHolder(context, (UISubTable)component);
    }

    public void encodeBeforeRows(ResponseWriter writer, FacesContext facesContext, RowHolderBase holder) throws IOException {
        RowHolder rowHolder = (RowHolder)holder;
        Row row = rowHolder.getRow();
        if (rowHolder.isPartialUpdate()) {
            facesContext.getPartialViewContext().getPartialResponseWriter().startUpdate(row.getClientId(facesContext) + ":tb");
        }
        this.encodeTableBodyStart(writer, facesContext, (UISubTable)row);
        this.encodeHeaderFacet(writer, facesContext, (UISubTable)row, false);
    }

    public void encodeRow(ResponseWriter writer, FacesContext context, RowHolderBase holder) throws IOException {
        RowHolder rowHolder = (RowHolder)holder;
        Row row = rowHolder.getRow();
        rowHolder.setRowStart(true);
        Iterator components = row.columns();
        while (components.hasNext()) {
            this.encodeColumn(context, writer, (UIColumn)components.next(), rowHolder);
        }
        this.encodeRowEnd(writer);
    }

    public void encodeAfterRows(ResponseWriter writer, FacesContext facesContext, RowHolderBase holder) throws IOException {
        RowHolder rowHolder = (RowHolder)holder;
        Row row = rowHolder.getRow();
        UISubTable subTable = (UISubTable)row;
        this.encodeFooterFacet(writer, facesContext, subTable, false);
        this.encodeTableBodyEnd(writer);
        this.encodeHiddenContainer(writer, facesContext, subTable);
        if (rowHolder.isPartialUpdate()) {
            facesContext.getPartialViewContext().getPartialResponseWriter().endUpdate();
        }
    }

    public boolean encodeParentTBody(UIDataTableBase dataTableBase) {
        return true;
    }

    public void encodeHiddenInput(ResponseWriter writer, FacesContext facesContext, UIDataTableBase dataTableBase) throws IOException {
        UISubTable subTable = (UISubTable)dataTableBase;
        String stateId = subTable.getClientId(facesContext) + STATE;
        writer.startElement("input", (UIComponent)subTable);
        writer.writeAttribute("id", (Object)stateId, null);
        writer.writeAttribute("name", (Object)stateId, null);
        writer.writeAttribute("type", RendererUtils.HTML.INPUT_TYPE_HIDDEN, null);
        int state = subTable.isExpanded() ? 1 : 0;
        writer.writeAttribute("value", (Object)state, null);
        writer.endElement("input");
        String optionsId = subTable.getClientId(facesContext) + OPTIONS;
        writer.startElement("input", (UIComponent)subTable);
        writer.writeAttribute("id", (Object)optionsId, null);
        writer.writeAttribute("name", (Object)optionsId, null);
        writer.writeAttribute("type", RendererUtils.HTML.INPUT_TYPE_HIDDEN, null);
        writer.endElement("input");
    }

    public boolean containsThead() {
        return false;
    }

    public HeaderEncodeStrategy getHeaderEncodeStrategy(UIComponent column, String tableFacetName) {
        return new AbstractTableRenderer.SimpleHeaderEncodeStrategy();
    }

    public void encodeClientScript(ResponseWriter writer, FacesContext facesContext, UIDataTableBase component) throws IOException {
        UISubTable subTable = (UISubTable)component;
        String id = subTable.getClientId(facesContext);
        UIForm nestingForm = this.getUtils().getNestingForm(facesContext, (UIComponent)subTable);
        String formId = nestingForm != null ? nestingForm.getClientId(facesContext) : "";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("stateInput", subTable.getClientId(facesContext) + STATE);
        options.put("optionsInput", subTable.getClientId(facesContext) + OPTIONS);
        options.put("expandMode", subTable.getExpandMode());
        options.put("eventOptions", (String)AjaxRendererUtils.buildEventOptions((FacesContext)facesContext, (UIComponent)subTable));
        JSFunction jsFunction = new JSFunction("new RichFaces.ui.SubTable", new Object[0]);
        jsFunction.addParameter((Object)id);
        jsFunction.addParameter((Object)formId);
        jsFunction.addParameter(options);
        writer.startElement("script", (UIComponent)subTable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)jsFunction.toScript(), null);
        writer.endElement("script");
    }

    public String getTableSkinClass() {
        return "rf-st";
    }

    public String getRowSkinClass() {
        return "rf-st-r";
    }

    public String getFirstRowSkinClass() {
        return "rf-st-f-r";
    }

    public String getHeaderRowSkinClass() {
        return "rf-st-h-r";
    }

    public String getHeaderFirstRowSkinClass() {
        return "rf-st-h-f-r";
    }

    public String getCellSkinClass() {
        return "rf-st-c";
    }

    public String getHeaderCellSkinClass() {
        return "rf-st-h-c";
    }

    public String getColumnHeaderCellSkinClass() {
        return "rf-st-sh-c";
    }

    public String getColumnHeaderSkinClass() {
        return "rf-st-sh";
    }

    public String getFooterSkinClass() {
        return "rf-st-f";
    }

    public String getFooterCellSkinClass() {
        return "rf-st-f-c";
    }

    public String getFooterFirstRowSkinClass() {
        return "rf-st-f-f";
    }

    public String getColumnFooterCellSkinClass() {
        return "rf-st-sf-c";
    }

    public String getColumnFooterSkinClass() {
        return "rf-st-sf";
    }

    public String getColumnFooterFirstSkinClass() {
        return "rf-st-sf-f";
    }

    public String getColumnHeaderFirstSkinClass() {
        return "rf-st-sh-f";
    }

    public String getFooterFirstSkinClass() {
        return "rf-st-f-f";
    }

    public String getHeaderFirstSkinClass() {
        return "rf-st-h-f";
    }

    public String getHeaderSkinClass() {
        return "rf-st-h";
    }

    public String getNoDataClass() {
        return "rf-st-nd-c";
    }

    protected void setupTableStartElement(FacesContext context, UIComponent component) {
        this.put(context, component.getClientId(context), "cellElement", "td");
    }
}

