/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.HashMap;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.UISubTable;
import org.richfaces.component.UISubTableToggleControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="subtable-toggler.js")})
public class SubTableToggleControlRendererBase
extends RendererBase {
    private static final String DISPLAY_NONE = "display: none;";
    private static final String EXPAND_STATE = "expand";
    private static final String COLLAPSE_STATE = "collapse";
    private static final String UP_ICON_URL = "up_icon.gif";
    private static final String DOWN_ICON_URL = "down_icon.gif";

    protected void doDecode(FacesContext context, UIComponent component) {
        context.getPartialViewContext().getRenderIds().add(component.getClientId(context));
    }

    protected void encodeControl(FacesContext context, UIComponent component) throws IOException {
        UISubTableToggleControl toggleControl = (UISubTableToggleControl)component;
        UISubTable subTable = this.findComponent(context, toggleControl);
        if (subTable != null) {
            ResponseWriter writer = context.getResponseWriter();
            String toggleId = toggleControl.getClientId(context);
            HashMap<String, Object> options = this.encodeOptions(context, toggleControl, subTable);
            String switchType = subTable.getExpandMode();
            boolean expanded = subTable.isExpanded();
            this.encodeControl(context, writer, toggleControl, switchType, expanded, false);
            this.encodeControl(context, writer, toggleControl, switchType, !expanded, true);
            JSFunction jsFunction = new JSFunction("new RichFaces.ui.SubTableToggler", new Object[0]);
            jsFunction.addParameter((Object)toggleId);
            jsFunction.addParameter(options);
            writer.startElement("script", (UIComponent)subTable);
            writer.writeText((Object)jsFunction.toScript(), null);
            writer.endElement("script");
            subTable.addToggleListener(toggleControl);
        }
    }

    protected void encodeControl(FacesContext context, ResponseWriter writer, UISubTableToggleControl control, String switchType, boolean expanded, boolean visible) throws IOException {
        String label;
        String state = this.getState(expanded);
        String styleClass = this.getStyleClass(context, control);
        String style = this.getStyle(context, control);
        writer.startElement("span", (UIComponent)control);
        if (!visible) {
            writer.writeAttribute("style", (Object)DISPLAY_NONE, null);
        }
        writer.writeAttribute("id", (Object)(control.getClientId() + ":" + state), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("style", (Object)style, null);
        boolean encodeDefault = true;
        UIComponent controlFacet = control.getFacet(state);
        if (controlFacet != null && controlFacet.isRendered()) {
            if (!visible) {
                String facetStyle = (String)controlFacet.getAttributes().get("style");
                facetStyle = facetStyle != null ? facetStyle + "; display: none" : "; display: none";
                controlFacet.getAttributes().put("style", facetStyle);
            }
            controlFacet.encodeAll(context);
            encodeDefault = false;
        }
        String expandIcon = control.getExpandIcon();
        String collapseIcon = control.getCollapseIcon();
        if (expandIcon != null && collapseIcon != null && expandIcon.trim().length() > 0 && collapseIcon.trim().length() > 0) {
            String image;
            String string = image = expanded ? expandIcon : collapseIcon;
            if (image != null && image.trim().length() > 0) {
                writer.startElement("img", (UIComponent)control);
                writer.writeAttribute("src", (Object)image, null);
                writer.writeAttribute("alt", (Object)"", null);
                writer.endElement("img");
            }
            encodeDefault = false;
        }
        String string = label = expanded ? control.getExpandLabel() : control.getCollapseLabel();
        if (label != null && label.trim().length() > 0) {
            writer.startElement("a", (UIComponent)control);
            writer.writeAttribute("href", (Object)"javascript:void(0);", null);
            writer.writeText((Object)label, null);
            writer.endElement("a");
            encodeDefault = false;
        }
        if (encodeDefault) {
            String image;
            expandIcon = context.getApplication().getResourceHandler().createResource(UP_ICON_URL).getRequestPath();
            collapseIcon = context.getApplication().getResourceHandler().createResource(DOWN_ICON_URL).getRequestPath();
            String string2 = image = expanded ? expandIcon : collapseIcon;
            if (image != null && image.trim().length() > 0) {
                writer.startElement("img", (UIComponent)control);
                writer.writeAttribute("src", (Object)image, null);
                writer.writeAttribute("alt", (Object)"", null);
                writer.endElement("img");
            }
        }
        writer.endElement("span");
    }

    public HashMap<String, Object> encodeOptions(FacesContext context, UISubTableToggleControl toggleControl, UISubTable subTable) {
        String forId = subTable.getClientId(context);
        String toggleControlId = toggleControl.getClientId(context);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("forId", forId);
        options.put("expandControl", toggleControlId + ":expand");
        options.put("collapseControl", toggleControlId + ":collapse");
        String eventName = toggleControl.getEvent();
        eventName = eventName.trim().startsWith("on") ? eventName.substring(2) : eventName;
        options.put("eventName", eventName);
        return options;
    }

    public String getStyleClass(FacesContext context, UISubTableToggleControl control) {
        return null;
    }

    public String getStyle(FacesContext context, UISubTableToggleControl control) {
        return null;
    }

    protected UISubTable findComponent(FacesContext context, UISubTableToggleControl toggleControl) {
        UIComponent subTable;
        String forId = toggleControl.getFor();
        if (forId != null && forId.length() > 0 && (subTable = this.getUtils().findComponentFor(context, (UIComponent)toggleControl, forId)) instanceof UISubTable) {
            return (UISubTable)subTable;
        }
        return null;
    }

    protected String getState(boolean expand) {
        return expand ? EXPAND_STATE : COLLAPSE_STATE;
    }
}

