/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.ajax4jsf.application.DebugOutputMaker;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class DebugLifecycle
extends Lifecycle
implements PhaseListener {
    public static final String DEBUG_LYFECYCLE_ID = "DEBUG";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    public static final String PHASE_ID_PARAM = "org.ajax4jsf.CURRENT_PHASE";
    private static final long serialVersionUID = -3247965217553145312L;
    private static final Logger LOG = RichfacesLogger.APPLICATION.getLogger();
    private static final DebugOutputMaker DEBUG_OUTPUT = new DebugOutputMaker();
    private Lifecycle defaultLifecycle;

    public DebugLifecycle(Lifecycle default1) {
        this.defaultLifecycle = default1;
    }

    public DebugLifecycle(LifecycleFactory defaultFactory) {
        this.defaultLifecycle = defaultFactory.getLifecycle("DEFAULT");
        this.defaultLifecycle.addPhaseListener((PhaseListener)this);
    }

    public void addPhaseListener(PhaseListener arg0) {
        this.defaultLifecycle.addPhaseListener(arg0);
    }

    public void execute(FacesContext context) throws FacesException {
        try {
            this.defaultLifecycle.execute(context);
        }
        catch (FacesException e) {
            DEBUG_OUTPUT.writeErrorMessage(context, e, "execute");
            context.responseComplete();
        }
    }

    public PhaseListener[] getPhaseListeners() {
        return this.defaultLifecycle.getPhaseListeners();
    }

    public void removePhaseListener(PhaseListener arg0) {
        this.defaultLifecycle.removePhaseListener(arg0);
    }

    public void render(FacesContext context) throws FacesException {
        try {
            this.defaultLifecycle.render(context);
        }
        catch (FacesException e) {
            DEBUG_OUTPUT.writeErrorMessage(context, e, "render");
            context.responseComplete();
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("End phase " + event.getPhaseId().toString());
        }
    }

    public void beforePhase(PhaseEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start phase " + event.getPhaseId().toString());
        }
        event.getFacesContext().getExternalContext().getRequestMap().put(PHASE_ID_PARAM, event.getPhaseId());
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

