/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import java.util.concurrent.ConcurrentMap;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.util.ELUtils;
import org.richfaces.application.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextInitParameters {
    public static final String[] DATATABLE_USES_VIEW_LOCALE = new String[]{"org.richfaces.datatableUsesViewLocale"};
    public static final String HANDLE_VIEW_EXPIRED_ON_CLIENT = "org.ajax4jsf.handleViewExpiredOnClient";
    public static final String STD_CONTROLS_SKINNING_PARAM = "org.richfaces.ENABLE_CONTROL_SKINNING";
    public static final String STD_CONTROLS_SKINNING_CLASSES_PARAM = "org.richfaces.ENABLE_CONTROL_SKINNING_CLASSES";
    public static final String[] QUEUE_ENABLED = new String[]{"org.richfaces.queue.enabled"};
    private static final String INIT_PARAM_PREFIX = ContextInitParameters.class.getSimpleName() + ":";
    private static final Object NULL = new Object(){

        public String toString() {
            return ContextInitParameters.class.getSimpleName() + ": null Object";
        }
    };

    private ContextInitParameters() {
    }

    public static boolean isDatatableUsesViewLocale(FacesContext context) {
        return ContextInitParameters.getBoolean(context, DATATABLE_USES_VIEW_LOCALE, false);
    }

    public static boolean isQueueEnabled(FacesContext context) {
        return ContextInitParameters.getBoolean(context, QUEUE_ENABLED, true);
    }

    public static boolean isStandardControlSkinningEnabled(FacesContext context) {
        String paramValue = ContextInitParameters.evaluateInitParameter(context, STD_CONTROLS_SKINNING_PARAM);
        return ContextInitParameters.getBooleanValue(paramValue, true);
    }

    public static boolean isStandardControlSkinningClassesEnabled(FacesContext context) {
        String paramValue = ContextInitParameters.evaluateInitParameter(context, STD_CONTROLS_SKINNING_CLASSES_PARAM);
        return ContextInitParameters.getBooleanValue(paramValue, false);
    }

    static int getInteger(FacesContext context, String[] paramNames, int defaulValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaulValue;
        }
        try {
            return Integer.parseInt(initParameter);
        }
        catch (NumberFormatException e) {
            throw new FacesException("Context parameter " + paramNames + " must have integer value");
        }
    }

    static String getString(FacesContext context, String[] paramNames, String defaulValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaulValue;
        }
        return initParameter;
    }

    static boolean getBoolean(FacesContext context, String[] paramNames, boolean defaulValue) {
        String initParameter = ContextInitParameters.getInitParameter(context, paramNames);
        if (null == initParameter) {
            return defaulValue;
        }
        if ("true".equalsIgnoreCase(initParameter) || "yes".equalsIgnoreCase(initParameter)) {
            return true;
        }
        if ("false".equalsIgnoreCase(initParameter) || "no".equalsIgnoreCase(initParameter)) {
            return false;
        }
        throw new FacesException("Illegal value [" + initParameter + "] for a init parameter +" + paramNames + ", only logical values 'true' or 'false' is allowed");
    }

    static String getInitParameter(FacesContext context, String[] paramNames) {
        ExternalContext externalContext = context.getExternalContext();
        String value = null;
        for (int i = 0; i < paramNames.length && null == value; ++i) {
            value = externalContext.getInitParameter(paramNames[i]);
        }
        return value;
    }

    private static boolean getBooleanValue(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String stringValue = (String)value;
        return "true".equalsIgnoreCase(stringValue) || "yes".equalsIgnoreCase(stringValue);
    }

    private static ConcurrentMap<Object, Object> getExpressionsMap(FacesContext context) {
        ConcurrentMap concurrentStorage = ServiceTracker.getConcurrentStorage((FacesContext)context);
        return concurrentStorage;
    }

    private static String evaluateInitParameter(FacesContext context, String parameterName) {
        String parameterKey;
        ConcurrentMap<Object, Object> expressionsMap = ContextInitParameters.getExpressionsMap(context);
        Object parameterValue = expressionsMap.get(parameterKey = INIT_PARAM_PREFIX + parameterName);
        if (parameterValue == null) {
            String initParameter = context.getExternalContext().getInitParameter(parameterName);
            if (initParameter != null) {
                if (ELUtils.isValueReference(initParameter)) {
                    Application application = context.getApplication();
                    ExpressionFactory expressionFactory = application.getExpressionFactory();
                    parameterValue = expressionFactory.createValueExpression(context.getELContext(), initParameter, String.class);
                } else {
                    parameterValue = initParameter;
                }
            } else {
                parameterValue = NULL;
            }
            expressionsMap.put(parameterKey, parameterValue);
        }
        return ContextInitParameters.evaluateInitParameterExpression(context, parameterValue);
    }

    private static String evaluateInitParameterExpression(FacesContext context, Object parameterValue) {
        if (parameterValue == NULL || parameterValue == null) {
            return null;
        }
        if (parameterValue instanceof ValueExpression) {
            ValueExpression expression = (ValueExpression)parameterValue;
            return (String)expression.getValue(context.getELContext());
        }
        return parameterValue.toString();
    }
}

