/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.HtmlDimensions;
import org.ajax4jsf.util.NumericDataInputStream;
import org.ajax4jsf.util.NumericDataOutputStream;
import org.richfaces.resource.AbstractBaseResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Java2Dresource
extends AbstractBaseResource
implements StateHolder {
    private static final String SKIN_MARKER = "Skin.";
    private ImageType imageType;

    public Java2Dresource(ImageType imageType) {
        this.imageType = imageType;
    }

    public void populateParameters(Map<String, String> parameters) {
    }

    public abstract Dimension getDimension();

    protected void paint(Graphics2D graphics2D, Dimension dimension) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        Dimension dimension = this.getDimension();
        int width = dimension.width;
        int height = dimension.height;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (width > 0 && height > 0) {
            BufferedImage image = this.imageType.createImage(width, height);
            Graphics2D g2d = image.createGraphics();
            try {
                this.paint(g2d, dimension);
            }
            finally {
                g2d.dispose();
            }
            try {
                ImageIO.write((RenderedImage)image, this.imageType.getFormatName(), baos);
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public String getContentType() {
        return this.imageType.getMimeType();
    }

    protected void writeState(FacesContext context, NumericDataOutputStream stream) {
    }

    protected void readState(FacesContext context, NumericDataInputStream stream) {
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        this.readState(context, new NumericDataInputStream((byte[])state));
    }

    public Object saveState(FacesContext context) {
        NumericDataOutputStream stream = new NumericDataOutputStream();
        this.writeState(context, stream);
        return stream.getBytes();
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    protected String getValueParameter(FacesContext context, String name) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String value = (String)skin.getParameter(context, name);
        if (value == null || value.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            value = (String)skin.getParameter(context, name);
        }
        return value;
    }

    protected String encodeSkinParameter(String param) {
        if (param.startsWith(SKIN_MARKER)) {
            String name = param.substring(SKIN_MARKER.length());
            return this.getValueParameter(FacesContext.getCurrentInstance(), name);
        }
        return param;
    }

    protected Integer getColorValueParameter(FacesContext context, String name, boolean useDefault) {
        Skin skin = useDefault ? SkinFactory.getInstance().getDefaultSkin(context) : SkinFactory.getInstance().getSkin(context);
        return this.decodeColor((String)skin.getParameter(context, name));
    }

    protected Integer getHeight(FacesContext context, String heightParamName) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String height = (String)skin.getParameter(context, heightParamName);
        if (height == null || height.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            height = (String)skin.getParameter(context, heightParamName);
        }
        if (height != null && height.length() != 0) {
            return HtmlDimensions.decode(height).intValue();
        }
        return 16;
    }

    protected Integer decodeColor(String value) {
        if (value != null && value.length() != 0) {
            return HtmlColor.decode(value).getRGB();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        GIF("gif"){

            public BufferedImage createImage(int width, int height) {
                return ImageType.createARGBImage(width, height);
            }
        }
        ,
        PNG("png"){

            public BufferedImage createImage(int width, int height) {
                return ImageType.createARGBImage(width, height);
            }
        }
        ,
        PNG8("png"){

            public BufferedImage createImage(int width, int height) {
                return new BufferedImage(width, height, 13, SAFE_WEB_COLORS_MODEL);
            }
        }
        ,
        JPEG("jpeg"){

            public BufferedImage createImage(int width, int height) {
                return new BufferedImage(width, height, 1);
            }
        };

        protected static final IndexColorModel SAFE_WEB_COLORS_MODEL;
        private String formatName;
        private String mimeType;

        private ImageType(String formatName) {
            this.formatName = formatName;
            this.mimeType = "image/" + formatName;
        }

        private static BufferedImage createARGBImage(int width, int height) {
            return new BufferedImage(width, height, 2);
        }

        protected abstract BufferedImage createImage(int var1, int var2);

        protected String getFormatName() {
            return this.formatName;
        }

        protected String getMimeType() {
            return this.mimeType;
        }

        static {
            byte[] webLevels = new byte[]{0, 51, 102, -103, -52, -1};
            int colorsNumber = webLevels.length * webLevels.length * webLevels.length;
            byte[] r = new byte[colorsNumber];
            byte[] g = new byte[colorsNumber];
            byte[] b = new byte[colorsNumber];
            r[0] = 0;
            g[0] = 0;
            b[0] = 0;
            for (int i = 0; i < webLevels.length; ++i) {
                for (int j = 0; j < webLevels.length; ++j) {
                    for (int k = 0; k < webLevels.length; ++k) {
                        int colorNum = i * webLevels.length * webLevels.length + j * webLevels.length + k;
                        r[colorNum] = webLevels[i];
                        g[colorNum] = webLevels[j];
                        b[colorNum] = webLevels[k];
                    }
                }
            }
            SAFE_WEB_COLORS_MODEL = new IndexColorModel(8, colorsNumber, r, g, b, 0);
        }
    }
}

