/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.ResourceContext;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class ResourceLifecycle
extends Lifecycle {
    private static final Logger LOG = RichfacesLogger.RESOURCE.getLogger();
    private Lifecycle lifecycle;

    public void addPhaseListener(PhaseListener arg0) {
    }

    public void execute(FacesContext arg0) throws FacesException {
    }

    public PhaseListener[] getPhaseListeners() {
        return null;
    }

    public void removePhaseListener(PhaseListener arg0) {
    }

    public void render(FacesContext arg0) throws FacesException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(ResourceContext resourceContext, InternetResource resource) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext) {
            Lifecycle facesLifecycle = this.getFacesLifecycle();
            PhaseListener[] phaseListeners = facesLifecycle.getPhaseListeners();
            PhaseEvent restoreViewEvent = new PhaseEvent(facesContext, PhaseId.RESTORE_VIEW, (Lifecycle)this);
            this.processPhaseListeners(phaseListeners, restoreViewEvent, true);
            if (facesContext.getResponseComplete()) {
                return;
            }
            UIViewRoot savedViewRoot = facesContext.getViewRoot();
            try {
                UIViewRoot root = new UIViewRoot();
                String key = resource.getKey();
                if (null != key && !key.startsWith("/")) {
                    key = "/" + key;
                }
                root.setViewId(key);
                root.setLocale(Locale.getDefault());
                root.setRenderKitId("HTML_BASIC");
                facesContext.setViewRoot(root);
                this.processPhaseListeners(phaseListeners, restoreViewEvent, false);
                if (facesContext.getResponseComplete()) return;
                PhaseEvent renderViewEvent = new PhaseEvent(facesContext, PhaseId.RENDER_RESPONSE, (Lifecycle)this);
                this.processPhaseListeners(phaseListeners, renderViewEvent, true);
                this.sendResource(resourceContext, resource);
                this.processPhaseListeners(phaseListeners, renderViewEvent, false);
                return;
            }
            finally {
                if (null != savedViewRoot) {
                    facesContext.setViewRoot(savedViewRoot);
                }
            }
        } else {
            this.sendResource(resourceContext, resource);
        }
    }

    private void processPhaseListeners(PhaseListener[] phaseListeners, PhaseEvent phaseEvent, boolean beforePhase) {
        if (beforePhase) {
            for (int i = 0; i < phaseListeners.length; ++i) {
                PhaseListener phaseListener = phaseListeners[i];
                this.invokePhaseListener(phaseListener, phaseEvent, beforePhase);
            }
        } else {
            for (int i = phaseListeners.length - 1; i >= 0; --i) {
                PhaseListener phaseListener = phaseListeners[i];
                this.invokePhaseListener(phaseListener, phaseEvent, beforePhase);
            }
        }
    }

    private void invokePhaseListener(PhaseListener phaseListener, PhaseEvent phaseEvent, boolean beforePhase) {
        if (phaseEvent.getPhaseId().equals(phaseListener.getPhaseId()) || PhaseId.ANY_PHASE.equals(phaseListener.getPhaseId())) {
            try {
                if (beforePhase) {
                    phaseListener.beforePhase(phaseEvent);
                } else {
                    phaseListener.afterPhase(phaseEvent);
                }
            }
            catch (Exception e) {
                LOG.debug("Exception in PhaseListener, phase :" + phaseEvent.getPhaseId().toString() + (beforePhase ? " : beforePhase" : " : afterPhase"), (Throwable)e);
            }
        }
    }

    private void sendResource(ResourceContext resourceContext, InternetResource resource) throws IOException {
        resource.sendHeaders(resourceContext);
        resource.send(resourceContext);
    }

    protected synchronized Lifecycle getFacesLifecycle() {
        if (this.lifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            this.lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
        }
        return this.lifecycle;
    }
}

